/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.convert.BooleanConverter;
import org.miaixz.bus.core.convert.CharacterConverter;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.convert.NumberConverter;
import org.miaixz.bus.core.lang.exception.ConvertException;

public class PrimitiveConverter
extends AbstractConverter
implements MatcherConverter,
Serializable {
    private static final long serialVersionUID = 2852271020075L;
    public static final PrimitiveConverter INSTANCE = new PrimitiveConverter();

    @Override
    public boolean match(Type targetType, Class<?> rawType, Object value) {
        return rawType.isPrimitive();
    }

    @Override
    protected Object convertInternal(Class<?> primitiveClass, Object value) {
        Comparable<Byte> result;
        if (Byte.TYPE == primitiveClass) {
            result = NumberConverter.INSTANCE.convert(Byte.class, value);
        } else if (Short.TYPE == primitiveClass) {
            result = NumberConverter.INSTANCE.convert(Short.class, value);
        } else if (Integer.TYPE == primitiveClass) {
            result = NumberConverter.INSTANCE.convert(Integer.class, value);
        } else if (Long.TYPE == primitiveClass) {
            result = NumberConverter.INSTANCE.convert(Long.class, value);
        } else if (Float.TYPE == primitiveClass) {
            result = NumberConverter.INSTANCE.convert(Float.class, value);
        } else if (Double.TYPE == primitiveClass) {
            result = NumberConverter.INSTANCE.convert(Double.class, value);
        } else if (Character.TYPE == primitiveClass) {
            result = CharacterConverter.INSTANCE.convert(Character.class, value);
        } else if (Boolean.TYPE == primitiveClass) {
            result = BooleanConverter.INSTANCE.convert(Boolean.class, value);
        } else {
            throw new ConvertException("Unsupported target type: {}", primitiveClass);
        }
        if (null == result) {
            throw new ConvertException("Can not support {} to {}", value, primitiveClass);
        }
        return result;
    }
}

