/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import org.miaixz.bus.core.convert.ArrayConverter;
import org.miaixz.bus.core.convert.CastConverter;
import org.miaixz.bus.core.convert.ClassConverter;
import org.miaixz.bus.core.convert.CollectionConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.convert.ConverterWithRoot;
import org.miaixz.bus.core.convert.DateConverter;
import org.miaixz.bus.core.convert.EmptyBeanConverter;
import org.miaixz.bus.core.convert.EntryConverter;
import org.miaixz.bus.core.convert.EnumConverter;
import org.miaixz.bus.core.convert.KBeanConverter;
import org.miaixz.bus.core.convert.MapConverter;
import org.miaixz.bus.core.convert.MatcherConverter;
import org.miaixz.bus.core.convert.NumberConverter;
import org.miaixz.bus.core.convert.PrimitiveConverter;
import org.miaixz.bus.core.convert.RecordConverter;
import org.miaixz.bus.core.convert.TimeZoneConverter;
import org.miaixz.bus.core.convert.ZoneIdConverter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.exception.ConvertException;
import org.miaixz.bus.core.xyz.StreamKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class SpecialConverter
extends ConverterWithRoot
implements Serializable {
    private static final long serialVersionUID = 2852271836876L;
    private final Set<MatcherConverter> converterSet;

    public SpecialConverter(Converter rootConverter) {
        super(rootConverter);
        this.converterSet = SpecialConverter.initDefault(Assert.notNull(rootConverter));
    }

    private static Converter getConverterFromSet(Set<? extends MatcherConverter> converterSet, Type type, Class<?> rawType, Object value) {
        return StreamKit.of(converterSet).filter(predicate -> predicate.match(type, rawType, value)).findFirst().orElse(null);
    }

    private static Set<MatcherConverter> initDefault(Converter rootConverter) {
        LinkedHashSet<MatcherConverter> converterSet = new LinkedHashSet<MatcherConverter>(64);
        converterSet.add(CollectionConverter.INSTANCE);
        converterSet.add(new MapConverter(rootConverter));
        converterSet.add(new EntryConverter(rootConverter));
        converterSet.add(CastConverter.INSTANCE);
        converterSet.add(DateConverter.INSTANCE);
        converterSet.add(PrimitiveConverter.INSTANCE);
        converterSet.add(NumberConverter.INSTANCE);
        converterSet.add(EnumConverter.INSTANCE);
        converterSet.add(ArrayConverter.INSTANCE);
        converterSet.add(RecordConverter.INSTANCE);
        converterSet.add(KBeanConverter.INSTANCE);
        converterSet.add(ClassConverter.INSTANCE);
        converterSet.add(EmptyBeanConverter.INSTANCE);
        converterSet.add(TimeZoneConverter.INSTANCE);
        converterSet.add(ZoneIdConverter.INSTANCE);
        return converterSet;
    }

    @Override
    public Object convert(Type targetType, Object value) throws ConvertException {
        return this.convert(targetType, TypeKit.getClass(targetType), value);
    }

    public Object convert(Type targetType, Class<?> rawType, Object value) throws ConvertException {
        Converter converter = this.getConverter(targetType, rawType, value);
        return null == converter ? null : converter.convert(targetType, value);
    }

    public Converter getConverter(Type type, Class<?> rawType, Object value) {
        return SpecialConverter.getConverterFromSet(this.converterSet, type, rawType, value);
    }
}

