/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.convert;

import java.lang.reflect.Type;
import java.sql.Blob;
import java.sql.Clob;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.Function;
import org.miaixz.bus.core.convert.AbstractConverter;
import org.miaixz.bus.core.convert.stringer.BlobStringer;
import org.miaixz.bus.core.convert.stringer.ClobStringer;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.XmlKit;
import org.w3c.dom.Node;

public class StringConverter
extends AbstractConverter {
    private static final long serialVersionUID = 2852271992351L;
    private Map<Class<?>, Function<Object, String>> stringer;

    public StringConverter putStringer(Class<?> clazz, Function<Object, String> stringFunction) {
        if (null == this.stringer) {
            this.stringer = new HashMap();
        }
        this.stringer.put(clazz, stringFunction);
        return this;
    }

    @Override
    protected String convertInternal(Class<?> targetClass, Object value) {
        Function<Object, String> stringFunction;
        if (MapKit.isNotEmpty(this.stringer) && null != (stringFunction = this.stringer.get(targetClass))) {
            return stringFunction.apply(value);
        }
        if (value instanceof TimeZone) {
            return ((TimeZone)value).getID();
        }
        if (value instanceof Node) {
            return XmlKit.toString((Node)value);
        }
        if (value instanceof Clob) {
            return ClobStringer.INSTANCE.apply(value);
        }
        if (value instanceof Blob) {
            return BlobStringer.INSTANCE.apply(value);
        }
        if (value instanceof Type) {
            return ((Type)value).getTypeName();
        }
        return this.convertToString(value);
    }
}

