/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.miaixz.bus.core.center.regex.Pattern;
import org.miaixz.bus.core.xyz.PatternKit;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;

public class CreditCode {
    public static final java.util.regex.Pattern CREDIT_CODE_PATTERN = Pattern.CREDIT_CODE_PATTERN;
    private static final int[] WEIGHT = new int[]{1, 3, 9, 27, 19, 26, 16, 17, 20, 29, 25, 13, 8, 24, 10, 30, 28};
    private static final char[] BASE_CODE_ARRAY = "0123456789ABCDEFGHJKLMNPQRTUWXY".toCharArray();
    private static final Map<Character, Integer> CODE_INDEX_MAP = new ConcurrentHashMap<Character, Integer>();

    public static boolean isCreditCodeSimple(CharSequence creditCode) {
        if (StringKit.isBlank(creditCode)) {
            return false;
        }
        return PatternKit.isMatch(CREDIT_CODE_PATTERN, creditCode);
    }

    public static boolean isCreditCode(CharSequence creditCode) {
        if (!CreditCode.isCreditCodeSimple(creditCode)) {
            return false;
        }
        int parityBit = CreditCode.getParityBit(creditCode);
        if (parityBit < 0) {
            return false;
        }
        return creditCode.charAt(17) == BASE_CODE_ARRAY[parityBit];
    }

    public static String randomCreditCode() {
        int num;
        int i;
        StringBuilder buf = new StringBuilder(18);
        for (i = 0; i < 2; ++i) {
            num = RandomKit.randomInt(BASE_CODE_ARRAY.length - 1);
            buf.append(Character.toUpperCase(BASE_CODE_ARRAY[num]));
        }
        for (i = 2; i < 8; ++i) {
            num = RandomKit.randomInt(10);
            buf.append(BASE_CODE_ARRAY[num]);
        }
        for (i = 8; i < 17; ++i) {
            num = RandomKit.randomInt(BASE_CODE_ARRAY.length - 1);
            buf.append(BASE_CODE_ARRAY[num]);
        }
        String code = buf.toString();
        return code + BASE_CODE_ARRAY[CreditCode.getParityBit(code)];
    }

    private static int getParityBit(CharSequence creditCode) {
        int sum = 0;
        for (int i = 0; i < 17; ++i) {
            Integer codeIndex = CODE_INDEX_MAP.get(Character.valueOf(creditCode.charAt(i)));
            if (null == codeIndex) {
                return -1;
            }
            sum += codeIndex * WEIGHT[i];
        }
        int result = 31 - sum % 31;
        return result == 31 ? 0 : result;
    }

    static {
        for (int i = 0; i < BASE_CODE_ARRAY.length; ++i) {
            CODE_INDEX_MAP.put(Character.valueOf(BASE_CODE_ARRAY[i]), i);
        }
    }
}

