/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data;

import org.miaixz.bus.core.data.masking.MaskingManager;
import org.miaixz.bus.core.data.masking.MaskingProcessor;
import org.miaixz.bus.core.data.masking.TextMaskingRule;
import org.miaixz.bus.core.lang.EnumValue;
import org.miaixz.bus.core.xyz.StringKit;

public class Masking {
    private static final MaskingProcessor DEFAULT_PROCESSOR = Masking.createDefaultProcessor();

    public static String mask(String text) {
        return DEFAULT_PROCESSOR.mask(text);
    }

    public static String mask(String text, MaskingProcessor processor) {
        return processor.mask(text);
    }

    public static String masking(EnumValue.Masking masking, CharSequence text) {
        return MaskingManager.getInstance().masking(masking.name(), text);
    }

    public static String clear() {
        return "";
    }

    public static String clearToNull() {
        return null;
    }

    public static Long userId() {
        return 0L;
    }

    public static String firstMask(CharSequence text) {
        return MaskingManager.EMPTY.firstMask(text);
    }

    public static String chineseName(CharSequence fullName) {
        return Masking.firstMask(fullName);
    }

    public static String idCardNum(CharSequence idCardNum, int front, int end) {
        return MaskingManager.EMPTY.idCardNum(idCardNum, front, end);
    }

    public static String fixedPhone(CharSequence num) {
        return MaskingManager.EMPTY.fixedPhone(num);
    }

    public static String mobilePhone(CharSequence num) {
        return MaskingManager.EMPTY.mobilePhone(num);
    }

    public static String address(CharSequence address, int sensitiveSize) {
        return MaskingManager.EMPTY.address(address, sensitiveSize);
    }

    public static String email(CharSequence email) {
        return MaskingManager.EMPTY.email(email);
    }

    public static String password(CharSequence password) {
        if (StringKit.isBlank(password)) {
            return "";
        }
        return StringKit.repeat('*', 10);
    }

    public static String carLicense(CharSequence carLicense) {
        return MaskingManager.EMPTY.carLicense(carLicense);
    }

    public static String bankCard(CharSequence bankCardNo) {
        return MaskingManager.EMPTY.bankCard(bankCardNo);
    }

    public static String ipv4(CharSequence ipv4) {
        return MaskingManager.EMPTY.ipv4(ipv4);
    }

    public static String ipv6(CharSequence ipv6) {
        return MaskingManager.EMPTY.ipv6(ipv6);
    }

    public static MaskingProcessor createProcessor(boolean preserveHtmlTags) {
        return new MaskingProcessor(preserveHtmlTags);
    }

    public static TextMaskingRule createEmailRule() {
        return new TextMaskingRule("\u90ae\u7bb1", "[\\w.-]+@[\\w.-]+\\.\\w+", EnumValue.Masking.PARTIAL, null).setPreserveLeft(1).setPreserveRight(0).setMaskChar('*');
    }

    public static TextMaskingRule createUrlRule(String replacement) {
        return new TextMaskingRule("\u7f51\u5740", "https?://[\\w.-]+(?:/[\\w.-]*)*", EnumValue.Masking.REPLACE, replacement);
    }

    public static TextMaskingRule createSensitiveWordRule(String pattern) {
        return new TextMaskingRule("\u654f\u611f\u8bcd", pattern, EnumValue.Masking.FULL, null).setMaskChar('*');
    }

    public static TextMaskingRule createCustomRule(String name, String pattern, EnumValue.Masking masking, String replacement) {
        return new TextMaskingRule(name, pattern, masking, replacement);
    }

    public static TextMaskingRule createPartialMaskRule(String name, String pattern, int preserveLeft, int preserveRight, char maskChar) {
        return new TextMaskingRule(name, pattern, preserveLeft, preserveRight, maskChar);
    }

    private static MaskingProcessor createDefaultProcessor() {
        MaskingProcessor processor = new MaskingProcessor(true);
        processor.addRule(new TextMaskingRule("\u90ae\u7bb1", "[\\w.-]+@[\\w.-]+\\.\\w+", EnumValue.Masking.PARTIAL, "[\u90ae\u7bb1\u5df2\u9690\u85cf]").setPreserveLeft(1).setPreserveRight(0).setMaskChar('*'));
        processor.addRule(new TextMaskingRule("\u7f51\u5740", "https?://[\\w.-]+(?:/[\\w.-]*)*", EnumValue.Masking.REPLACE, "[\u7f51\u5740\u5df2\u9690\u85cf]"));
        processor.addRule(new TextMaskingRule("\u654f\u611f\u8bcd", "(\u673a\u5bc6|\u7edd\u5bc6|\u5185\u90e8\u8d44\u6599|\u79d8\u5bc6|\u4fdd\u5bc6)", EnumValue.Masking.FULL, "***").setMaskChar('*'));
        return processor;
    }
}

