/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data.id;

import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;

public class ObjectId {
    private static final AtomicInteger NEXT_INC = new AtomicInteger(RandomKit.randomInt());
    private static final char[] MACHINE_CODE = ObjectId.initMachineCode();

    public static boolean isValid(String s) {
        if (s == null) {
            return false;
        }
        int len = (s = StringKit.removeAll((CharSequence)s, (CharSequence)"-")).length();
        if (len != 24) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F') continue;
            return false;
        }
        return true;
    }

    public static byte[] nextBytes() {
        return ObjectId.next().getBytes();
    }

    public static String id() {
        return ObjectId.next();
    }

    public static String next() {
        char[] ids = new char[24];
        int epoch = (int)(System.currentTimeMillis() / 1000L);
        for (int i = 7; i >= 0; --i) {
            ids[i] = Normal.DIGITS_16_LOWER[epoch & 0xF];
            epoch >>>= 4;
        }
        System.arraycopy(MACHINE_CODE, 0, ids, 8, 8);
        int seq = NEXT_INC.incrementAndGet();
        for (int i = 23; i >= 16; --i) {
            ids[i] = Normal.DIGITS_16_LOWER[seq & 0xF];
            seq >>>= 4;
        }
        return new String(ids);
    }

    public static String next(boolean withHyphen) {
        if (!withHyphen) {
            return ObjectId.next();
        }
        char[] ids = new char[26];
        ids[8] = 45;
        ids[17] = 45;
        int epoch = (int)(System.currentTimeMillis() / 1000L);
        for (int i = 7; i >= 0; --i) {
            ids[i] = Normal.DIGITS_16_LOWER[epoch & 0xF];
            epoch >>>= 4;
        }
        System.arraycopy(MACHINE_CODE, 0, ids, 9, 8);
        int seq = NEXT_INC.incrementAndGet();
        for (int i = 25; i >= 18; --i) {
            ids[i] = Normal.DIGITS_16_LOWER[seq & 0xF];
            seq >>>= 4;
        }
        return new String(ids);
    }

    private static char[] initMachineCode() {
        char[] macAndPid = new char[8];
        Random random = new Random();
        for (int i = 7; i >= 0; --i) {
            macAndPid[i] = Normal.DIGITS_16_LOWER[random.nextInt() & 0xF];
        }
        return macAndPid;
    }
}

