/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data.id;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Random;
import org.miaixz.bus.core.codec.No128;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;

public class UUID
implements Serializable,
Comparable<UUID> {
    private static final long serialVersionUID = 2852276107807L;
    private final No128 idValue;

    private UUID(byte[] data) {
        int i;
        long msb = 0L;
        long lsb = 0L;
        assert (data.length == 16) : "data must be 16 bytes in length";
        for (i = 0; i < 8; ++i) {
            msb = msb << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            lsb = lsb << 8 | (long)(data[i] & 0xFF);
        }
        this.idValue = new No128(msb, lsb);
    }

    public UUID(long mostSigBits, long leastSigBits) {
        this.idValue = new No128(mostSigBits, leastSigBits);
    }

    public static UUID fastUUID() {
        return UUID.randomUUID(false);
    }

    public static UUID randomUUID() {
        return UUID.randomUUID(true);
    }

    public static UUID randomUUID(boolean isSecure) {
        return UUID.randomUUID(isSecure ? Holder.NUMBER_GENERATOR : RandomKit.getRandom());
    }

    public static UUID randomUUID(Random random) {
        byte[] randomBytes = RandomKit.randomBytes(16, random);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        randomBytes[8] = (byte)(randomBytes[8] & 0x3F);
        randomBytes[8] = (byte)(randomBytes[8] | 0xFFFFFF80);
        return new UUID(randomBytes);
    }

    public static UUID nameUUIDFromBytes(byte[] name) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new InternalError("MD5 not supported");
        }
        byte[] md5Bytes = md.digest(name);
        md5Bytes[6] = (byte)(md5Bytes[6] & 0xF);
        md5Bytes[6] = (byte)(md5Bytes[6] | 0x30);
        md5Bytes[8] = (byte)(md5Bytes[8] & 0x3F);
        md5Bytes[8] = (byte)(md5Bytes[8] | 0xFFFFFF80);
        return new UUID(md5Bytes);
    }

    public static UUID fromString(String name) {
        String[] components = name.split("-");
        if (components.length != 5) {
            throw new IllegalArgumentException("Invalid UUID string: " + name);
        }
        for (int i = 0; i < 5; ++i) {
            components[i] = "0x" + components[i];
        }
        long mostSigBits = Long.decode(components[0]);
        mostSigBits <<= 16;
        mostSigBits |= Long.decode(components[1]).longValue();
        mostSigBits <<= 16;
        long leastSigBits = Long.decode(components[3]);
        leastSigBits <<= 48;
        return new UUID(mostSigBits |= Long.decode(components[2]).longValue(), leastSigBits |= Long.decode(components[4]).longValue());
    }

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public long getLeastSignificantBits() {
        return this.idValue.getLeastSigBits();
    }

    public long getMostSignificantBits() {
        return this.idValue.getMostSigBits();
    }

    public int version() {
        return (int)(this.getMostSignificantBits() >> 12 & 0xFL);
    }

    public int variant() {
        long leastSigBits = this.getLeastSignificantBits();
        return (int)(leastSigBits >>> (int)(64L - (leastSigBits >>> 62)) & leastSigBits >> 63);
    }

    public long timestamp() throws UnsupportedOperationException {
        long mostSigBits = this.getMostSignificantBits();
        this.checkTimeBase();
        return (mostSigBits & 0xFFFL) << 48 | (mostSigBits >> 16 & 0xFFFFL) << 32 | mostSigBits >>> 32;
    }

    public int clockSequence() throws UnsupportedOperationException {
        this.checkTimeBase();
        return (int)((this.getLeastSignificantBits() & 0x3FFF000000000000L) >>> 48);
    }

    public long node() throws UnsupportedOperationException {
        this.checkTimeBase();
        return this.getLeastSignificantBits() & 0xFFFFFFFFFFFFL;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean isSimple) {
        long mostSigBits = this.getLeastSignificantBits();
        long leastSigBits = this.getLeastSignificantBits();
        StringBuilder builder = StringKit.builder(isSimple ? 32 : 36);
        builder.append(UUID.digits(mostSigBits >> 32, 8));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(mostSigBits >> 16, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(mostSigBits, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(leastSigBits >> 48, 4));
        if (!isSimple) {
            builder.append('-');
        }
        builder.append(UUID.digits(leastSigBits, 12));
        return builder.toString();
    }

    public int hashCode() {
        long hilo = this.getLeastSignificantBits() ^ this.getMostSignificantBits();
        return (int)(hilo >> 32) ^ (int)hilo;
    }

    public boolean equals(Object object) {
        if (null == object || object.getClass() != UUID.class) {
            return false;
        }
        UUID id = (UUID)object;
        long mostSigBits = this.getLeastSignificantBits();
        long leastSigBits = this.getLeastSignificantBits();
        return mostSigBits == id.getMostSignificantBits() && leastSigBits == id.getLeastSignificantBits();
    }

    @Override
    public int compareTo(UUID val) {
        int compare = Long.compare(this.getMostSignificantBits(), val.getMostSignificantBits());
        if (0 == compare) {
            compare = Long.compare(this.getLeastSignificantBits(), val.getLeastSignificantBits());
        }
        return compare;
    }

    private void checkTimeBase() {
        if (this.version() != 1) {
            throw new UnsupportedOperationException("Not a time-based UUID");
        }
    }

    private static class Holder {
        static final SecureRandom NUMBER_GENERATOR = RandomKit.getSecureRandom();

        private Holder() {
        }
    }
}

