/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.data.masking;

import java.util.HashSet;
import java.util.Set;
import org.miaixz.bus.core.lang.EnumValue;

public class TextMaskingRule {
    private String name;
    private String pattern;
    private EnumValue.Masking masking;
    private String replacement;
    private int preserveLeft;
    private int preserveRight;
    private char maskChar = (char)42;
    private boolean processHtmlTags = false;
    private Set<String> excludeTags = new HashSet<String>();
    private Set<String> includeTags = new HashSet<String>();

    public TextMaskingRule() {
    }

    public TextMaskingRule(String name, String pattern, EnumValue.Masking masking, String replacement) {
        this.name = name;
        this.pattern = pattern;
        this.masking = masking;
        this.replacement = replacement;
    }

    public TextMaskingRule(String name, String pattern, int preserveLeft, int preserveRight, char maskChar) {
        this.name = name;
        this.pattern = pattern;
        this.masking = EnumValue.Masking.PARTIAL;
        this.preserveLeft = preserveLeft;
        this.preserveRight = preserveRight;
        this.maskChar = maskChar;
    }

    public String getName() {
        return this.name;
    }

    public TextMaskingRule setName(String name) {
        this.name = name;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public TextMaskingRule setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public EnumValue.Masking getMasking() {
        return this.masking;
    }

    public TextMaskingRule setMasking(EnumValue.Masking masking) {
        this.masking = masking;
        return this;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public TextMaskingRule setReplacement(String replacement) {
        this.replacement = replacement;
        return this;
    }

    public int getPreserveLeft() {
        return this.preserveLeft;
    }

    public TextMaskingRule setPreserveLeft(int preserveLeft) {
        this.preserveLeft = preserveLeft;
        return this;
    }

    public int getPreserveRight() {
        return this.preserveRight;
    }

    public TextMaskingRule setPreserveRight(int preserveRight) {
        this.preserveRight = preserveRight;
        return this;
    }

    public char getMaskChar() {
        return this.maskChar;
    }

    public TextMaskingRule setMaskChar(char maskChar) {
        this.maskChar = maskChar;
        return this;
    }

    public boolean isProcessHtmlTags() {
        return this.processHtmlTags;
    }

    public TextMaskingRule setProcessHtmlTags(boolean processHtmlTags) {
        this.processHtmlTags = processHtmlTags;
        return this;
    }

    public Set<String> getExcludeTags() {
        return this.excludeTags;
    }

    public TextMaskingRule setExcludeTags(Set<String> excludeTags) {
        this.excludeTags = excludeTags;
        return this;
    }

    public TextMaskingRule addExcludeTag(String tag) {
        this.excludeTags.add(tag.toLowerCase());
        return this;
    }

    public Set<String> getIncludeTags() {
        return this.includeTags;
    }

    public TextMaskingRule setIncludeTags(Set<String> includeTags) {
        this.includeTags = includeTags;
        return this;
    }

    public TextMaskingRule addIncludeTag(String tag) {
        this.includeTags.add(tag.toLowerCase());
        return this;
    }
}

