/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.compress;

import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.StandardCopyOption;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.miaixz.bus.core.io.compress.ZipFileResource;
import org.miaixz.bus.core.io.compress.ZipResource;
import org.miaixz.bus.core.io.compress.ZipStream;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.core.xyz.ZipKit;

public class ZipReader
implements Closeable {
    private static final int DEFAULT_MAX_SIZE_DIFF = 100;
    private final ZipResource resource;
    private int maxSizeDiff = 100;

    public ZipReader(ZipFile zipFile) {
        this(new ZipFileResource(zipFile));
    }

    public ZipReader(ZipInputStream zin) {
        this(new ZipStream(zin));
    }

    public ZipReader(ZipResource resource) {
        this.resource = resource;
    }

    public static ZipReader of(File zipFile, Charset charset) {
        return new ZipReader(ZipKit.toZipFile(zipFile, charset));
    }

    public static ZipReader of(InputStream in, Charset charset) {
        return new ZipReader(new ZipInputStream(in, charset));
    }

    public ZipReader setMaxSizeDiff(int maxSizeDiff) {
        this.maxSizeDiff = maxSizeDiff;
        return this;
    }

    public InputStream get(String path) {
        return this.resource.get(path);
    }

    public File readTo(File outFile) throws InternalException {
        return this.readTo(outFile, null);
    }

    public File readTo(File outFile, Predicate<ZipEntry> entryFilter) throws InternalException {
        this.read(zipEntry -> {
            if (null == entryFilter || entryFilter.test((ZipEntry)zipEntry)) {
                this.readEntry((ZipEntry)zipEntry, outFile);
            }
        });
        return outFile;
    }

    public ZipReader read(Consumer<ZipEntry> consumer) throws InternalException {
        this.resource.read(consumer, this.maxSizeDiff);
        return this;
    }

    @Override
    public void close() throws InternalException {
        IoKit.closeQuietly(this.resource);
    }

    private void readEntry(ZipEntry zipEntry, File outFile) {
        String path = zipEntry.getName();
        if (FileKit.isWindows()) {
            path = StringKit.replace((CharSequence)path, (CharSequence)"*", "_");
        }
        File outItemFile = FileKit.file(outFile, path);
        if (zipEntry.isDirectory()) {
            outItemFile.mkdirs();
        } else {
            FileKit.copy(this.resource.get(zipEntry), outItemFile, new StandardCopyOption[0]);
        }
    }
}

