/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.copier;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import org.miaixz.bus.core.io.copier.IoCopier;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;

public class FileChannelCopier
extends IoCopier<FileChannel, FileChannel> {
    public FileChannelCopier(long count) {
        super(-1, count, null);
    }

    public static FileChannelCopier of() {
        return FileChannelCopier.of(-1L);
    }

    public static FileChannelCopier of(long count) {
        return new FileChannelCopier(count);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long copy(FileInputStream in, FileOutputStream out) throws InternalException {
        long l;
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        try {
            inChannel = in.getChannel();
            outChannel = out.getChannel();
            l = this.copy(inChannel, outChannel);
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(outChannel);
            IoKit.closeQuietly(inChannel);
            throw throwable;
        }
        IoKit.closeQuietly(outChannel);
        IoKit.closeQuietly(inChannel);
        return l;
    }

    @Override
    public long copy(FileChannel source, FileChannel target) {
        try {
            return this.doCopySafely(source, target);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    private long doCopySafely(FileChannel inChannel, FileChannel outChannel) throws IOException {
        long writeBytes;
        long totalBytes = inChannel.size();
        if (this.count > 0L && this.count < totalBytes) {
            totalBytes = this.count;
        }
        long pos = 0L;
        for (long remaining = totalBytes; remaining > 0L; remaining -= writeBytes) {
            writeBytes = inChannel.transferTo(pos, remaining, outChannel);
            pos += writeBytes;
        }
        return totalBytes;
    }
}

