/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Predicate;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.wrapper.SimpleWrapper;

public class DelegatePath
extends SimpleWrapper<Path>
implements Path,
Resource {
    public DelegatePath(String first, String ... more) {
        this(Paths.get(first, more));
    }

    public DelegatePath(URI uri) {
        this(Paths.get(uri));
    }

    public DelegatePath(Path path) {
        super(path);
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
    }

    public Path getRawPath() {
        return (Path)this.raw;
    }

    @Override
    public FileSystem getFileSystem() {
        return ((Path)this.raw).getFileSystem();
    }

    @Override
    public boolean isAbsolute() {
        return ((Path)this.raw).isAbsolute();
    }

    @Override
    public Path getRoot() {
        Path root = ((Path)this.raw).getRoot();
        return root == null ? null : new DelegatePath(root);
    }

    @Override
    public Path getFileName() {
        Path fileName = ((Path)this.raw).getFileName();
        return fileName == null ? null : new DelegatePath(fileName);
    }

    @Override
    public Path getParent() {
        Path parent = ((Path)this.raw).getParent();
        return parent == null ? null : new DelegatePath(parent);
    }

    @Override
    public int getNameCount() {
        return ((Path)this.raw).getNameCount();
    }

    @Override
    public Path getName(int index) {
        return new DelegatePath(((Path)this.raw).getName(index));
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        return new DelegatePath(((Path)this.raw).subpath(beginIndex, endIndex));
    }

    @Override
    public boolean startsWith(Path other) {
        if (other instanceof DelegatePath) {
            return ((Path)this.raw).startsWith((Path)((DelegatePath)other).raw);
        }
        return ((Path)this.raw).startsWith(other);
    }

    @Override
    public boolean startsWith(String other) {
        return ((Path)this.raw).startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (other instanceof DelegatePath) {
            return ((Path)this.raw).endsWith((Path)((DelegatePath)other).raw);
        }
        return ((Path)this.raw).endsWith(other);
    }

    @Override
    public boolean endsWith(String other) {
        return ((Path)this.raw).endsWith(other);
    }

    @Override
    public Path normalize() {
        return new DelegatePath(((Path)this.raw).normalize());
    }

    @Override
    public Path resolve(Path other) {
        if (other instanceof DelegatePath) {
            return new DelegatePath(((Path)this.raw).resolve((Path)((DelegatePath)other).raw));
        }
        return new DelegatePath(((Path)this.raw).resolve(other));
    }

    @Override
    public Path resolve(String other) {
        return new DelegatePath(((Path)this.raw).resolve(other));
    }

    @Override
    public Path resolveSibling(Path other) {
        if (other instanceof DelegatePath) {
            return new DelegatePath(((Path)this.raw).resolveSibling((Path)((DelegatePath)other).raw));
        }
        return new DelegatePath(((Path)this.raw).resolveSibling(other));
    }

    @Override
    public Path resolveSibling(String other) {
        return new DelegatePath(((Path)this.raw).resolveSibling(other));
    }

    @Override
    public Path relativize(Path other) {
        if (other instanceof DelegatePath) {
            return new DelegatePath(((Path)this.raw).relativize((Path)((DelegatePath)other).raw));
        }
        return new DelegatePath(((Path)this.raw).relativize(other));
    }

    @Override
    public URI toUri() {
        return ((Path)this.raw).toUri();
    }

    @Override
    public Path toAbsolutePath() {
        return new DelegatePath(((Path)this.raw).toAbsolutePath());
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        return new DelegatePath(((Path)this.raw).toRealPath(options));
    }

    @Override
    public File toFile() {
        return ((Path)this.raw).toFile();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        return ((Path)this.raw).register(watcher, events, modifiers);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        return ((Path)this.raw).register(watcher, events);
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private final Iterator<Path> itr;
            {
                this.itr = ((Path)DelegatePath.this.raw).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasNext();
            }

            @Override
            public Path next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new DelegatePath(this.itr.next());
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        if (other instanceof DelegatePath) {
            return ((Path)this.raw).compareTo((Path)((DelegatePath)other).raw);
        }
        return ((Path)this.raw).compareTo(other);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof DelegatePath) {
            return ((Path)this.raw).equals(((DelegatePath)other).raw);
        }
        if (other instanceof Path) {
            return ((Path)this.raw).equals(other);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Path)this.raw).hashCode();
    }

    @Override
    public String toString() {
        return ((Path)this.raw).toString();
    }

    public boolean exists(LinkOption ... options) {
        return Files.exists((Path)this.raw, options);
    }

    public boolean isSubOf(Path parent) {
        return PathResolve.isSub(parent, (Path)this.raw);
    }

    public boolean notExists(LinkOption ... options) {
        return Files.notExists((Path)this.raw, options);
    }

    public boolean isDirectory(LinkOption ... options) {
        return Files.isDirectory((Path)this.raw, options);
    }

    public boolean isFile(LinkOption ... options) {
        return Files.isRegularFile((Path)this.raw, options);
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink((Path)this.raw);
    }

    public boolean isOther() {
        return PathResolve.isOther((Path)this.raw);
    }

    public boolean isExecutable() {
        return Files.isExecutable((Path)this.raw);
    }

    public boolean isReadable() {
        return Files.isReadable((Path)this.raw);
    }

    public boolean isWritable() {
        return Files.isWritable((Path)this.raw);
    }

    @Override
    public long size() {
        try {
            return Files.size((Path)this.raw);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    @Override
    public String getName() {
        return PathResolve.getName((Path)this.raw);
    }

    public void delete() {
        try {
            Files.delete((Path)this.raw);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public boolean deleteIfExists() {
        try {
            return Files.deleteIfExists((Path)this.raw);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public DelegatePath createDirectory(FileAttribute<?> ... attrs) {
        try {
            return new DelegatePath(Files.createDirectory((Path)this.raw, attrs));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public DelegatePath createDirectories(FileAttribute<?> ... attrs) {
        try {
            return new DelegatePath(Files.createDirectories((Path)this.raw, attrs));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public DelegatePath createFile(FileAttribute<?> ... attrs) {
        try {
            return new DelegatePath(Files.createFile((Path)this.raw, attrs));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public DelegatePath createTempDirectory(String prefix, FileAttribute<?> ... attrs) {
        try {
            return new DelegatePath(Files.createTempDirectory((Path)this.raw, prefix, attrs));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public DelegatePath createTempFile(String prefix, String suffix, FileAttribute<?> ... attrs) {
        try {
            return new DelegatePath(Files.createTempFile((Path)this.raw, prefix, suffix, attrs));
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public DelegatePath copyTo(Path target, CopyOption ... options) {
        Path actualTarget = target;
        if (target instanceof DelegatePath) {
            actualTarget = (Path)((DelegatePath)target).raw;
        }
        try {
            Files.copy((Path)this.raw, actualTarget, options);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return new DelegatePath(actualTarget);
    }

    public DelegatePath moveTo(Path target, CopyOption ... options) {
        Path actualTarget = target;
        if (target instanceof DelegatePath) {
            actualTarget = (Path)((DelegatePath)target).raw;
        }
        try {
            Files.move((Path)this.raw, actualTarget, options);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return new DelegatePath(actualTarget);
    }

    public boolean isDirEmpty() {
        return PathResolve.isDirEmpty(this);
    }

    public Path[] listFiles(Predicate<? super Path> filter) {
        return PathResolve.listFiles(this, filter);
    }

    public void walkFiles(Set<FileVisitOption> options, int maxDepth, FileVisitor<? super Path> visitor) {
        try {
            Files.walkFileTree((Path)this.raw, options, maxDepth, visitor);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public BasicFileAttributes getAttributes(LinkOption ... options) {
        return PathResolve.getAttributes((Path)this.raw, options);
    }

    public BufferedInputStream getStream(LinkOption ... options) {
        return PathResolve.getInputStream(this, options);
    }

    @Override
    public InputStream getStream() {
        return this.getStream(new LinkOption[0]);
    }

    @Override
    public URL getUrl() {
        try {
            return ((Path)this.raw).toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new InternalException(e);
        }
    }

    public Reader getReader(Charset charset, OpenOption ... options) {
        return PathResolve.getReader(this, charset, options);
    }

    @Override
    public byte[] readBytes() {
        return PathResolve.readBytes(this);
    }

    public BufferedOutputStream getOutputStream(OpenOption ... options) {
        return PathResolve.getOutputStream(this, options);
    }

    public String getMimeType() {
        return PathResolve.getMimeType(this);
    }
}

