/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.miaixz.bus.core.center.date.culture.en.Units;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.io.file.FileMode;
import org.miaixz.bus.core.io.file.LineWatcher;
import org.miaixz.bus.core.io.watch.SimpleWatcher;
import org.miaixz.bus.core.io.watch.WatchKind;
import org.miaixz.bus.core.io.watch.WatchMonitor;
import org.miaixz.bus.core.lang.Console;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.WatchKit;

public class FileTailer
implements Serializable {
    private static final long serialVersionUID = 2852227513936L;
    public static final ConsumerX<String> CONSOLE_HANDLER = new ConsoleLineHandler();
    private final Charset charset;
    private final ConsumerX<String> lineHandler;
    private final int initReadLine;
    private final long period;
    private final String filePath;
    private final RandomAccessFile randomAccessFile;
    private final ScheduledExecutorService executorService;
    private WatchMonitor fileWatchMonitor;
    private boolean stopOnRemove;

    public FileTailer(File file, ConsumerX<String> lineHandler) {
        this(file, lineHandler, 0);
    }

    public FileTailer(File file, ConsumerX<String> lineHandler, int initReadLine) {
        this(file, org.miaixz.bus.core.lang.Charset.UTF_8, lineHandler, initReadLine, Units.SECOND.getMillis());
    }

    public FileTailer(File file, Charset charset, ConsumerX<String> lineHandler) {
        this(file, charset, lineHandler, 0, Units.SECOND.getMillis());
    }

    public FileTailer(File file, Charset charset, ConsumerX<String> lineHandler, int initReadLine, long period) {
        FileTailer.checkFile(file);
        this.filePath = file.getAbsolutePath();
        this.charset = charset;
        this.lineHandler = lineHandler;
        this.period = period;
        this.initReadLine = initReadLine;
        this.randomAccessFile = FileKit.createRandomAccessFile(file, FileMode.r);
        this.executorService = Executors.newSingleThreadScheduledExecutor();
    }

    private static void checkFile(File file) {
        if (!file.exists()) {
            throw new InternalException("File [{}] not exist !", file.getAbsolutePath());
        }
        if (!file.isFile()) {
            throw new InternalException("Path [{}] is not a file !", file.getAbsolutePath());
        }
    }

    public void setStopOnRemove(boolean stopOnRemove) {
        this.stopOnRemove = stopOnRemove;
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean async) {
        try {
            this.readTail();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        LineWatcher lineWatcher = new LineWatcher(this.randomAccessFile, this.charset, this.lineHandler);
        ScheduledFuture<?> scheduledFuture = this.executorService.scheduleAtFixedRate(lineWatcher, 0L, this.period, TimeUnit.MILLISECONDS);
        if (this.stopOnRemove) {
            this.fileWatchMonitor = WatchKit.of(this.filePath, WatchKind.DELETE.getValue());
            this.fileWatchMonitor.setWatcher(new SimpleWatcher(){
                private static final long serialVersionUID = 2852571830580L;

                @Override
                public void onDelete(WatchEvent<?> event, WatchKey key) {
                    super.onDelete(event, key);
                    FileTailer.this.stop();
                    throw new InternalException("{} has been deleted", FileTailer.this.filePath);
                }
            });
            this.fileWatchMonitor.start();
        }
        if (!async) {
            try {
                scheduledFuture.get();
            }
            catch (ExecutionException e) {
                throw new InternalException(e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        try {
            this.executorService.shutdown();
        }
        catch (Throwable throwable) {
            IoKit.closeQuietly(this.randomAccessFile);
            IoKit.closeQuietly(this.fileWatchMonitor);
            throw throwable;
        }
        IoKit.closeQuietly(this.randomAccessFile);
        IoKit.closeQuietly(this.fileWatchMonitor);
    }

    private void readTail() throws IOException {
        long len = this.randomAccessFile.length();
        if (this.initReadLine > 0) {
            Stack<String> stack = new Stack<String>();
            long start = this.randomAccessFile.getFilePointer();
            long nextEnd = len - 1L < 0L ? 0L : len - 1L;
            this.randomAccessFile.seek(nextEnd);
            int currentLine = 0;
            while (nextEnd > start && currentLine < this.initReadLine) {
                String line;
                int c = this.randomAccessFile.read();
                if (c == 10 || c == 13) {
                    line = FileKit.readLine(this.randomAccessFile, this.charset);
                    if (null != line) {
                        stack.push(line);
                    }
                    ++currentLine;
                    --nextEnd;
                }
                this.randomAccessFile.seek(--nextEnd);
                if (nextEnd != 0L) continue;
                line = FileKit.readLine(this.randomAccessFile, this.charset);
                if (null == line) break;
                stack.push(line);
                break;
            }
            while (!stack.isEmpty()) {
                this.lineHandler.accept((String)stack.pop());
            }
        }
        try {
            this.randomAccessFile.seek(len);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static class ConsoleLineHandler
    implements ConsumerX<String> {
        private static final long serialVersionUID = 2852227591586L;

        @Override
        public void accepting(String line) {
            Console.log(line);
        }
    }
}

