/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.File;
import org.miaixz.bus.core.io.resource.Resource;

public class VirtualFile
extends File {
    private static final long serialVersionUID = 2852285580251L;
    private final Resource content;

    public VirtualFile(String pathname, Resource content) {
        super(pathname);
        if (pathname == null) {
            throw new IllegalArgumentException("pathname cannot be null");
        }
        this.content = content;
    }

    public VirtualFile(String parent, String child, Resource content) {
        super(parent, child);
        if (parent == null || child == null) {
            throw new IllegalArgumentException("parent and child cannot be null");
        }
        this.content = content;
    }

    public VirtualFile(File parent, String child, Resource content) {
        super(parent, child);
        if (parent == null || child == null) {
            throw new IllegalArgumentException("parent and child cannot be null");
        }
        this.content = content;
    }

    public Resource getContent() {
        return this.content;
    }

    public byte[] getBytes() {
        return null != this.content ? this.content.readBytes() : null;
    }

    @Override
    public boolean exists() {
        return null != this.content;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long length() {
        return null != this.content ? this.content.size() : 0L;
    }

    @Override
    public boolean canRead() {
        return this.exists();
    }

    @Override
    public boolean canWrite() {
        return false;
    }

    @Override
    public boolean canExecute() {
        return false;
    }

    @Override
    public long lastModified() {
        return System.currentTimeMillis();
    }
}

