/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.miaixz.bus.core.io.file.VirtualFile;
import org.miaixz.bus.core.io.resource.Resource;
import org.miaixz.bus.core.text.CharsBacker;
import org.miaixz.bus.core.xyz.StringKit;

public class VirtualPath
implements Path {
    private final String path;
    private final Resource content;

    public VirtualPath(String path, Resource content) {
        if (path == null) {
            throw new IllegalArgumentException("Path cannot be null");
        }
        this.path = path;
        this.content = content;
    }

    public Resource getContent() {
        return this.content;
    }

    public byte[] getBytes() {
        return null != this.content ? this.content.readBytes() : null;
    }

    @Override
    public FileSystem getFileSystem() {
        throw new UnsupportedOperationException("VirtualPath does not support FileSystem operations");
    }

    @Override
    public boolean isAbsolute() {
        return false;
    }

    @Override
    public Path getRoot() {
        return null;
    }

    @Override
    public Path getFileName() {
        int index = this.path.lastIndexOf(47);
        if (index == -1) {
            return new VirtualPath(this.path, this.content);
        }
        return new VirtualPath(this.path.substring(index + 1), this.content);
    }

    @Override
    public Path getParent() {
        int index = this.path.lastIndexOf(47);
        if (index == -1) {
            return null;
        }
        return new VirtualPath(this.path.substring(0, index), null);
    }

    @Override
    public int getNameCount() {
        if (StringKit.isEmpty(this.path)) {
            return 1;
        }
        if (StringKit.equals(this.path, "/")) {
            return 0;
        }
        return StringKit.count((CharSequence)this.path, "/");
    }

    @Override
    public Path getName(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index must be >= 0");
        }
        List<String> parts = CharsBacker.splitTrim(this.path, "/");
        if (index >= parts.size()) {
            throw new IllegalArgumentException("index exceeds name count");
        }
        return new VirtualPath(parts.get(index), index == parts.size() - 1 ? this.content : null);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        if (beginIndex < 0 || endIndex <= beginIndex) {
            throw new IllegalArgumentException("beginIndex or endIndex is invalid");
        }
        List<String> parts = CharsBacker.splitTrim(this.path, "/");
        if (endIndex > parts.size()) {
            throw new IllegalArgumentException("endIndex exceeds name count");
        }
        StringBuilder sb = new StringBuilder();
        for (int i = beginIndex; i < endIndex; ++i) {
            if (!sb.isEmpty()) {
                sb.append('/');
            }
            sb.append(parts.get(i));
        }
        return new VirtualPath(sb.toString(), endIndex == parts.size() ? this.content : null);
    }

    @Override
    public boolean startsWith(Path other) {
        if (!(other instanceof VirtualPath)) {
            return false;
        }
        VirtualPath otherPath = (VirtualPath)other;
        return this.path.startsWith(otherPath.path);
    }

    @Override
    public boolean startsWith(String other) {
        return this.path.startsWith(other);
    }

    @Override
    public boolean endsWith(Path other) {
        if (!(other instanceof VirtualPath)) {
            return false;
        }
        VirtualPath otherPath = (VirtualPath)other;
        return this.path.endsWith(otherPath.path);
    }

    @Override
    public boolean endsWith(String other) {
        return this.path.endsWith(other);
    }

    @Override
    public Path normalize() {
        return this;
    }

    @Override
    public Path resolve(Path other) {
        if (other.isAbsolute()) {
            return other;
        }
        if (other.toString().isEmpty()) {
            return this;
        }
        String newPath = this.path + "/" + String.valueOf(other);
        return new VirtualPath(newPath, other instanceof VirtualPath ? ((VirtualPath)other).content : null);
    }

    @Override
    public Path resolve(String other) {
        if (other.isEmpty()) {
            return this;
        }
        String newPath = this.path + "/" + other;
        return new VirtualPath(newPath, null);
    }

    @Override
    public Path resolveSibling(Path other) {
        if (other == null) {
            throw new NullPointerException("other cannot be null");
        }
        Path parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public Path resolveSibling(String other) {
        if (other == null) {
            throw new NullPointerException("other cannot be null");
        }
        Path parent = this.getParent();
        return parent == null ? new VirtualPath(other, null) : parent.resolve(other);
    }

    @Override
    public Path relativize(Path other) {
        if (!(other instanceof VirtualPath)) {
            throw new IllegalArgumentException("other must be a VirtualPath");
        }
        VirtualPath otherPath = (VirtualPath)other;
        if (this.path.isEmpty()) {
            return otherPath;
        }
        if (otherPath.path.startsWith(this.path + "/")) {
            return new VirtualPath(otherPath.path.substring(this.path.length() + 1), otherPath.content);
        }
        return otherPath;
    }

    @Override
    public URI toUri() {
        throw new UnsupportedOperationException("VirtualPath does not support URI conversion");
    }

    @Override
    public Path toAbsolutePath() {
        return this;
    }

    @Override
    public Path toRealPath(LinkOption ... options) {
        return this;
    }

    @Override
    public File toFile() {
        return new VirtualFile(this.path, this.content);
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException("VirtualPath does not support watch service");
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException("VirtualPath does not support watch service");
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int index = 0;
            private final List<String> parts;
            {
                this.parts = CharsBacker.splitTrim(VirtualPath.this.path, "/");
            }

            @Override
            public boolean hasNext() {
                return this.index < this.parts.size();
            }

            @Override
            public Path next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return new VirtualPath(this.parts.get(this.index++), this.index == this.parts.size() ? VirtualPath.this.content : null);
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        if (!(other instanceof VirtualPath)) {
            throw new ClassCastException("Cannot compare VirtualPath with " + other.getClass().getName());
        }
        VirtualPath otherPath = (VirtualPath)other;
        return this.path.compareTo(otherPath.path);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VirtualPath)) {
            return false;
        }
        VirtualPath otherPath = (VirtualPath)other;
        return this.path.equals(otherPath.path);
    }

    @Override
    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public String toString() {
        return this.path;
    }
}

