/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.miaixz.bus.core.center.iterator.ComputeIterator;
import org.miaixz.bus.core.io.buffer.FastByteBuffer;
import org.miaixz.bus.core.xyz.CharKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class LineInputStream
extends FilterInputStream
implements Iterable<byte[]> {
    public LineInputStream(InputStream in) {
        super(in);
    }

    public String readLine(Charset charset) {
        return StringKit.toString(this.readLine(), charset);
    }

    public byte[] readLine() {
        try {
            return this._readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<byte[]> iterator() {
        return new ComputeIterator<byte[]>(){

            @Override
            protected byte[] computeNext() {
                return LineInputStream.this.readLine();
            }
        };
    }

    private byte[] _readLine() throws IOException {
        int c;
        FastByteBuffer out = null;
        boolean precedingBackslash = false;
        while ((c = this.read()) > 0) {
            if (null == out) {
                out = new FastByteBuffer();
            }
            if (92 == c) {
                if (!precedingBackslash) {
                    precedingBackslash = true;
                    continue;
                }
                precedingBackslash = false;
            } else if (precedingBackslash) {
                if (CharKit.isBlankChar(c)) continue;
                precedingBackslash = false;
            } else if (10 == c) {
                int lastIndex = out.length() - 1;
                if (lastIndex < 0 || 13 != out.get(lastIndex)) break;
                return out.toArray(0, lastIndex);
            }
            out.append((byte)c);
        }
        return ObjectKit.apply(out, FastByteBuffer::toArray);
    }
}

