/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.IoKit;

public class StreamWriter {
    private final OutputStream out;
    private final boolean closeAfterWrite;

    public StreamWriter(OutputStream out, boolean closeAfterWrite) {
        this.out = out;
        this.closeAfterWrite = closeAfterWrite;
    }

    public static StreamWriter of(OutputStream out, boolean closeAfterWrite) {
        return new StreamWriter(out, closeAfterWrite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void write(byte[] content) throws InternalException {
        OutputStream out = this.out;
        try {
            out.write(content);
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                IoKit.closeQuietly(out);
                throw throwable;
            }
        }
        IoKit.closeQuietly(out);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObject(Object ... contents) throws InternalException {
        ObjectOutputStream osw;
        block6: {
            osw = null;
            if (!ArrayKit.isEmpty(contents)) break block6;
            if (!this.closeAfterWrite) return;
            IoKit.closeQuietly(osw);
            return;
        }
        try {
            osw = this.out instanceof ObjectOutputStream ? (ObjectOutputStream)this.out : new ObjectOutputStream(this.out);
            for (Object content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                IoKit.closeQuietly(osw);
                throw throwable;
            }
        }
        IoKit.closeQuietly(osw);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeString(Charset charset, CharSequence ... contents) throws InternalException {
        OutputStreamWriter osw = null;
        try {
            osw = IoKit.toWriter(this.out, charset);
            for (CharSequence content : contents) {
                if (content == null) continue;
                osw.write(Convert.toString(content, ""));
            }
            osw.flush();
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                IoKit.closeQuietly(osw);
                throw throwable;
            }
        }
        IoKit.closeQuietly(osw);
        return;
    }
}

