/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.stream;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.miaixz.bus.core.io.StreamProgress;
import org.miaixz.bus.core.io.stream.FastByteArrayOutputStream;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;

public class SyncInputStream
extends FilterInputStream {
    private final long length;
    private final boolean isIgnoreEOFError;
    private volatile boolean asyncFlag = true;

    public SyncInputStream(InputStream in, long length, boolean isAsync, boolean isIgnoreEOFError) {
        super(in);
        this.length = length;
        this.isIgnoreEOFError = isIgnoreEOFError;
        if (!isAsync) {
            this.sync();
        }
    }

    private static boolean isEOFException(Throwable e) {
        if (e instanceof FileNotFoundException) {
            return true;
        }
        return e instanceof EOFException || StringKit.containsIgnoreCase(e.getMessage(), "Premature EOF");
    }

    public SyncInputStream sync() {
        if (this.asyncFlag) {
            this.in = new ByteArrayInputStream(this.readBytes());
            this.asyncFlag = false;
        }
        return this;
    }

    public byte[] readBytes() {
        FastByteArrayOutputStream bytesOut = new FastByteArrayOutputStream(this.length > 0L ? (int)this.length : 1024);
        long length = this.copyTo(bytesOut, null);
        return length > 0L ? bytesOut.toByteArray() : new byte[]{};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long copyTo(OutputStream out, StreamProgress streamProgress) {
        long copyLength = -1L;
        try {
            copyLength = IoKit.copy(this.in, out, 8192, this.length, streamProgress);
        }
        catch (InternalException e) {
            block4: {
                try {
                    if (this.isIgnoreEOFError && SyncInputStream.isEOFException(e.getCause())) break block4;
                    throw e;
                }
                catch (Throwable throwable) {
                    IoKit.closeQuietly(this.in);
                    throw throwable;
                }
            }
            IoKit.closeQuietly(this.in);
        }
        IoKit.closeQuietly(this.in);
        return copyLength;
    }
}

