/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.io.watch;

import java.io.Closeable;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import org.miaixz.bus.core.io.file.PathResolve;
import org.miaixz.bus.core.io.watch.WatchServiceWrapper;
import org.miaixz.bus.core.io.watch.Watcher;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.StringKit;

public class WatchMonitor
extends Thread
implements Closeable,
Serializable {
    private static final long serialVersionUID = 2852236557339L;
    private final WatchServiceWrapper watchService;
    private Path dir;
    private Path file;
    private int maxDepth;
    private Watcher watcher;

    public WatchMonitor(Path dir, WatchEvent.Kind<?> ... events) {
        this(dir, 0, events);
    }

    public WatchMonitor(Path dir, int maxDepth, WatchEvent.Kind<?> ... events) {
        this.watchService = WatchServiceWrapper.of(events);
        this.dir = dir;
        this.maxDepth = maxDepth;
        this.init();
    }

    public WatchMonitor setWatcher(Watcher watcher) {
        this.watcher = watcher;
        return this;
    }

    @Override
    public void run() {
        this.watch();
    }

    public void watch() {
        this.watch(this.watcher);
    }

    public void watch(Watcher watcher) throws InternalException {
        if (this.watchService.isClosed()) {
            throw new InternalException("Watch Monitor is closed !");
        }
        this.registerPath();
        while (!this.watchService.isClosed()) {
            this.doTakeAndWatch(watcher);
        }
    }

    public WatchMonitor setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        return this;
    }

    @Override
    public void close() {
        this.watchService.close();
    }

    private void init() throws InternalException {
        if (!PathResolve.exists(this.dir, false)) {
            String lastPathEleStr;
            Path lastPathEle = FileKit.getLastPathEle(this.dir);
            if (null != lastPathEle && StringKit.contains((CharSequence)(lastPathEleStr = lastPathEle.toString()), '.') && !StringKit.endWithIgnoreCase(lastPathEleStr, ".d")) {
                this.file = this.dir;
                this.dir = this.file.getParent();
            }
            PathResolve.mkdir(this.dir);
        } else if (PathResolve.isFile(this.dir, false)) {
            this.file = this.dir;
            this.dir = this.file.getParent();
        }
    }

    private void doTakeAndWatch(Watcher watcher) {
        this.watchService.watch(watcher, watchEvent -> null == this.file || this.file.endsWith(watchEvent.context().toString()));
    }

    private void registerPath() {
        this.watchService.registerPath(this.dir, null != this.file ? 0 : this.maxDepth);
    }
}

