/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.math.BigInteger;
import java.net.URL;
import java.util.Date;
import java.util.Set;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.SetKit;

public class Normal {
    public static final int _1024 = 2048;
    public static final long KIBI = 1024L;
    public static final long MEBI = 0x100000L;
    public static final long GIBI = 0x40000000L;
    public static final long TEBI = 0x10000000000L;
    public static final long PEBI = 0x4000000000000L;
    public static final long EXBI = 0x1000000000000000L;
    public static final long MEGA = 1000000L;
    public static final long GIGA = 1000000000L;
    public static final long TERA = 1000000000000L;
    public static final long PETA = 1000000000000000L;
    public static final long EXA = 1000000000000000000L;
    public static final long KILO = 1000L;
    public static final BigInteger TWOS_COMPLEMENT_REF = BigInteger.ONE.shiftLeft(64);
    public static final int _32768 = 32768;
    public static final int _16384 = 16384;
    public static final int _8192 = 8192;
    public static final int _2048 = 4096;
    public static final int _512 = 1024;
    public static final int _256 = 512;
    public static final int _128 = 256;
    public static final int _64 = 128;
    public static final int _32 = 64;
    public static final int _24 = 24;
    public static final int _20 = 20;
    public static final int _18 = 18;
    public static final int _16 = 16;
    public static final int _12 = 12;
    public static final int _10 = 10;
    public static final int _9 = 9;
    public static final int _8 = 8;
    public static final int _7 = 7;
    public static final int _6 = 6;
    public static final int _5 = 5;
    public static final int _4 = 4;
    public static final int _3 = 3;
    public static final int _2 = 2;
    public static final int _1 = 1;
    public static final int _0 = 0;
    public static final int __1 = -1;
    public static final int __2 = -2;
    public static final int __3 = -3;
    public static final int __4 = -4;
    public static final int __5 = -5;
    public static final int __6 = -6;
    public static final int __7 = -7;
    public static final int __8 = -8;
    public static final int __9 = -9;
    public static final int __10 = -10;
    public static final int _65535 = 65535;
    public static final Long LONG_ZERO = 0L;
    public static final Long LONG_ONE = 1L;
    public static final Long LONG_MINUS_ONE = -1L;
    public static final Integer INTEGER_ZERO = 0;
    public static final Integer INTEGER_ONE = 1;
    public static final Integer INTEGER_TWO = 2;
    public static final Integer INTEGER_MINUS_ONE = -1;
    public static final Short SHORT_ZERO = 0;
    public static final Short SHORT_ONE = 1;
    public static final Short SHORT_MINUS_ONE = -1;
    public static final Byte BYTE_ZERO = 0;
    public static final Byte BYTE_ONE = 1;
    public static final Byte BYTE_MINUS_ONE = -1;
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Double DOUBLE_ONE = 1.0;
    public static final Double DOUBLE_MINUS_ONE = -1.0;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Float FLOAT_ONE = Float.valueOf(1.0f);
    public static final Float FLOAT_MINUS_ONE = Float.valueOf(-1.0f);
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final Date[] EMPTY_DATE_OBJECT_ARRAY = new Date[0];
    public static final long BYTES_PER_KB = 2048L;
    public static final long BYTES_PER_MB = 0x400000L;
    public static final long BYTES_PER_GB = 0x200000000L;
    public static final long BYTES_PER_TB = 0x100000000000L;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    public static final String NUMBER = "0123456789";
    public static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";
    public static final String LOWER_ALPHABET_NUMBER = "abcdefghijklmnopqrstuvwxyz0123456789";
    public static final String UPPER_ALPHABET_NUMBER = "abcdefghijklmnopqrstuvwxyz".toUpperCase() + "0123456789";
    public static final String EMPTY = "";
    public static final String NONE = "none";
    public static final String NULL = "null";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String IS = "is";
    public static final String SET = "set";
    public static final String GET = "get";
    public static final String EQUALS = "equals";
    public static final String HASHCODE = "hashCode";
    public static final String TOSTRING = "toString";
    public static final String UNKNOWN = "unknown";
    public static final String UNDEFINED = "undefined";
    public static final String FILE_URL_PREFIX = "file:";
    public static final String JAR_URL_PREFIX = "jar:";
    public static final String WAR_URL_PREFIX = "war:";
    public static final String CLASSPATH = "classpath:";
    public static final String PROJECT_URL_PREFIX = "project:";
    public static final String META_INF = "META-INF";
    public static final String META_INF_SERVICES = "META-INF/services";
    public static final String URL_PROTOCOL_FILE = "file";
    public static final String URL_PROTOCOL_JAR = "jar";
    public static final String LIB_PROTOCOL_JAR = "lib";
    public static final String URL_PROTOCOL_ZIP = "zip";
    public static final String URL_PROTOCOL_WSJAR = "wsjar";
    public static final String URL_PROTOCOL_VFSZIP = "vfszip";
    public static final String URL_PROTOCOL_VFSFILE = "vfsfile";
    public static final String URL_PROTOCOL_VFS = "vfs";
    public static final String JAR_URL_SEPARATOR = "!/";
    public static final String WAR_URL_SEPARATOR = "*/";
    public static final String HEX_ERROR = "0x%08X";
    public static final char[] OPERATOR_ZH = new char[]{'\u52a0', '\u51cf', '\u4e58', '\u9664'};
    public static final String[] CAPACITY_NAMES = new String[]{"B", "KB", "MB", "GB", "TB", "PB", "EB"};
    public static final String[] CAPACITY_SIMPLE_NAMES = new String[]{"B", "K", "M", "G", "T", "P", "E"};
    public static final String[] COLOR = new String[]{"\u767d", "\u9ed1", "\u78a7", "\u7eff", "\u9ec4", "\u767d", "\u8d64", "\u767d", "\u7d2b"};
    public static final String CNY = "CNY";
    public static final String[] SIMPLE_UNITS = new String[]{"", "\u5341", "\u767e", "\u5343"};
    public static final String[] TRADITIONAL_UNITS = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    public static final String[] SIMPLE_DIGITS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    public static final String[] TRADITIONAL_DIGITS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    public static final String[] EN_NUMBER = new String[]{"", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE"};
    public static final String[] EN_NUMBER_TEEN = new String[]{"TEN", "ELEVEN", "TWELVE", "THIRTEEN", "FOURTEEN", "FIFTEEN", "SIXTEEN", "SEVENTEEN", "EIGHTEEN", "NINETEEN"};
    public static final String[] EN_NUMBER_TEN = new String[]{"TEN", "TWENTY", "THIRTY", "FORTY", "FIFTY", "SIXTY", "SEVENTY", "EIGHTY", "NINETY"};
    public static final String[] EN_NUMBER_MORE = new String[]{"", "THOUSAND", "MILLION", "BILLION", "TRILLION"};
    public static final String[] TRUE_ARRAY = new String[]{"true", "t", "yes", "y", "ok", "1", "on", "\u662f", "\u771f", "\u6b63\u786e", "\u5bf9", "\u5c0d", "\u221a"};
    public static final String[] FALSE_ARRAY = new String[]{"false", "no", "n", "f", "0", "off", "\u5426", "\u9519", "\u932f", "\u5047", "\u00d7"};
    public static final char[] DIGITS_16_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final char[] DIGITS_16_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final byte[] ENCODE_64_TABLE = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    public static final byte[] DECODE_64_TABLE = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 62, -1, 62, -1, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, -1, -1, -1, -2, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, -1, -1, -1, -1, 63, -1, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51};
    public static final Set<Class<? extends Annotation>> META_ANNOTATIONS = SetKit.of(Target.class, Retention.class, Inherited.class, Documented.class, SuppressWarnings.class, Override.class, Deprecated.class);

    public static boolean isFileOrVfsURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        return Normal.isFileURL(url) || Normal.isVfsURL(url);
    }

    public static boolean isFileURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_FILE.equals(protocol);
    }

    public static boolean isVfsURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_VFSFILE.equals(protocol) || URL_PROTOCOL_VFS.equals(protocol);
    }

    public static boolean isJarURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        String protocol = url.getProtocol();
        return URL_PROTOCOL_JAR.equals(protocol) || URL_PROTOCOL_ZIP.equals(protocol) || URL_PROTOCOL_VFSZIP.equals(protocol) || URL_PROTOCOL_WSJAR.equals(protocol);
    }

    public static boolean isJarFileURL(URL url) {
        Assert.notNull(url, "URL must be not null", new Object[0]);
        return URL_PROTOCOL_FILE.equals(url.getProtocol()) && url.getPath().toLowerCase().endsWith(".jar");
    }
}

