/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.center.function.PredicateX;
import org.miaixz.bus.core.center.function.SupplierX;
import org.miaixz.bus.core.center.stream.EasyStream;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class Optional<T> {
    private static final Optional<?> EMPTY = new Optional<Object>(null);
    private final T value;
    private Throwable throwable;

    private Optional(T value) {
        this.value = value;
    }

    public static <T> Optional<T> empty() {
        return EMPTY;
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(Objects.requireNonNull(value));
    }

    public static <T> Optional<T> ofNullable(T value) {
        return value == null ? Optional.empty() : new Optional<T>(value);
    }

    public static <T extends CharSequence> Optional<T> ofBlankAble(T value) {
        return StringKit.isBlank(value) ? Optional.empty() : new Optional<T>(value);
    }

    public static <T, R extends Collection<T>> Optional<R> ofEmptyAble(R value) {
        return ObjectKit.isEmpty(value) ? Optional.empty() : new Optional<R>(value);
    }

    public static <T> Optional<T> ofTry(SupplierX<T> supplier) {
        try {
            return Optional.ofNullable(supplier.getting());
        }
        catch (Throwable e) {
            Optional<Object> empty = new Optional<Object>(null);
            empty.throwable = e;
            return empty;
        }
    }

    public static <T> Optional<T> of(java.util.Optional<? extends T> optional) {
        return Optional.ofNullable(optional.orElse(null));
    }

    public T getOrNull() {
        return this.value;
    }

    public T getOrThrow() throws NoSuchElementException {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean isFail() {
        return null != this.throwable;
    }

    public Optional<T> ifFail(Consumer<? super Throwable> action) throws NullPointerException {
        Objects.requireNonNull(action, "action is null");
        if (this.isFail()) {
            action.accept(this.throwable);
        }
        return this;
    }

    @SafeVarargs
    public final Optional<T> ifFail(Consumer<? super Throwable> action, Class<? extends Throwable> ... exs) throws NullPointerException {
        Objects.requireNonNull(action, "action is null");
        if (this.isFail() && EasyStream.of(exs).anyMatch(e -> e.isAssignableFrom(this.throwable.getClass()))) {
            action.accept(this.throwable);
        }
        return this;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public Optional<T> ifPresent(ConsumerX<? super T> action) {
        if (this.isPresent()) {
            try {
                action.accepting(this.value);
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }
        return this;
    }

    public Optional<T> filter(PredicateX<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (this.isEmpty() || this.isFail()) {
            return this;
        }
        try {
            return predicate.testing(this.value) ? this : Optional.empty();
        }
        catch (Throwable e) {
            Optional<Object> emptyWithError = new Optional<Object>(null);
            emptyWithError.throwable = e;
            return emptyWithError;
        }
    }

    public <U> Optional<U> map(FunctionX<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isFail()) {
            return this;
        }
        if (this.isEmpty()) {
            return Optional.empty();
        }
        return Optional.ofTry(() -> mapper.applying((T)this.value));
    }

    public <U> Optional<U> flattedMap(FunctionX<? super T, ? extends java.util.Optional<? extends U>> mapper) {
        java.util.Optional<? extends U> optional;
        Objects.requireNonNull(mapper);
        if (this.isFail()) {
            return this;
        }
        if (this.isEmpty()) {
            return Optional.empty();
        }
        try {
            optional = mapper.applying(this.value);
        }
        catch (Throwable e) {
            Optional<Object> emptyWithError = new Optional<Object>(null);
            emptyWithError.throwable = this.throwable;
            return emptyWithError;
        }
        return Optional.of(optional);
    }

    @SafeVarargs
    public final Optional<T> ifPresents(ConsumerX<T> ... actions) throws NullPointerException {
        return this.ifPresent(Stream.of(actions).reduce(ConsumerX::andThen).orElseGet(() -> o -> {}));
    }

    public Optional<T> or(SupplierX<? extends Optional<? extends T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isPresent()) {
            return this;
        }
        Optional<? extends T> r = supplier.get();
        return Objects.requireNonNull(r);
    }

    public Stream<T> stream() {
        if (this.isEmpty()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    public T orElse(T other) {
        return this.isPresent() ? this.value : other;
    }

    public T exceptionOrElse(T other) {
        return this.isFail() ? other : this.value;
    }

    public T orElseGet(SupplierX<? extends T> supplier) {
        return this.isPresent() ? this.value : supplier.get();
    }

    public Optional<T> orElseOpt(SupplierX<? extends T> supplier) {
        return this.or(() -> Optional.ofNullable(supplier.get()));
    }

    public T orElseRun(Runnable action) {
        if (this.isPresent()) {
            return this.value;
        }
        action.run();
        return null;
    }

    public T orElseThrow() {
        return this.orElseThrow(() -> new NoSuchElementException("No value present"));
    }

    public <X extends Throwable> T orElseThrow(SupplierX<? extends X> exceptionSupplier) throws X {
        if (this.isPresent()) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public java.util.Optional<T> toOptional() {
        return java.util.Optional.ofNullable(this.value);
    }

    public EasyStream<T> toEasyStream() {
        return EasyStream.of(this.value);
    }

    public static <T> Optional<T> findFirst(T ... values) {
        if (values == null || values.length == 0) {
            return Optional.empty();
        }
        for (T value : values) {
            if (value == null) continue;
            return Optional.of(value);
        }
        return Optional.empty();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)object;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return StringKit.toStringOrNull(this.value);
    }
}

