/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.exception;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Locale;
import java.util.ResourceBundle;
import lombok.Generated;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.lang.I18n;

public class RelevantException
extends IOException {
    private static final long serialVersionUID = 2852263392627L;
    protected String errcode;
    protected String errmsg;

    protected RelevantException() {
    }

    protected RelevantException(Throwable cause) {
        super(cause);
    }

    protected RelevantException(String errmsg) {
        super(errmsg);
    }

    protected RelevantException(Errors errors) {
        super(errors.getValue());
        this.errcode = errors.getKey();
        this.errmsg = errors.getValue();
    }

    public RelevantException(Errors errors, String errmsg) {
        super(errmsg);
        this.errcode = errors.getKey();
        this.errmsg = errmsg;
    }

    protected RelevantException(String errmsg, Throwable cause) {
        super(errmsg, cause);
    }

    protected RelevantException(String errcode, String errmsg) {
        super(errmsg);
        this.errcode = errcode;
        this.errmsg = errmsg;
    }

    protected RelevantException(String format, Object ... args) {
        super(String.format(format, args));
    }

    protected RelevantException(Throwable e, String fmt, Object ... args) {
        super(String.format(fmt, args), e);
    }

    protected static RelevantException noImplement() {
        return new RelevantException("Not implement yet!");
    }

    protected static RelevantException impossible() {
        return new RelevantException("r u kidding me?! It is impossible!");
    }

    protected static Throwable unwrapThrow(Throwable e) {
        InvocationTargetException itE;
        if (null == e) {
            return null;
        }
        if (e instanceof InvocationTargetException && null != (itE = (InvocationTargetException)e).getTargetException()) {
            return RelevantException.unwrapThrow(itE.getTargetException());
        }
        if (e instanceof RuntimeException && null != e.getCause()) {
            return RelevantException.unwrapThrow(e.getCause());
        }
        return e;
    }

    protected static boolean isCauseBy(Throwable e, Class<? extends Throwable> causeType) {
        if (e.getClass() == causeType) {
            return true;
        }
        Throwable cause = e.getCause();
        if (null == cause) {
            return false;
        }
        return RelevantException.isCauseBy(cause, causeType);
    }

    @Override
    public String getMessage() {
        if (this.errcode != null) {
            return this.errmsg;
        }
        return super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (this.errcode != null) {
            try {
                Locale locale = new Locale(I18n.AUTO_DETECT.lang());
                ResourceBundle bundle = ResourceBundle.getBundle("messages", locale);
                return bundle.getString(this.errcode);
            }
            catch (Exception e) {
                Errors.Entry entry = Errors.require(this.errcode);
                return entry != null ? entry.getValue() : this.getMessage();
            }
        }
        return super.getLocalizedMessage();
    }

    @Generated
    public String getErrcode() {
        return this.errcode;
    }

    @Generated
    public String getErrmsg() {
        return this.errmsg;
    }

    @Generated
    public void setErrcode(String errcode) {
        this.errcode = errcode;
    }

    @Generated
    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }
}

