/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.exception;

import java.util.Locale;
import java.util.ResourceBundle;
import lombok.Generated;
import org.miaixz.bus.core.basic.normal.Errors;
import org.miaixz.bus.core.lang.I18n;

public class UncheckedException
extends RuntimeException {
    private static final long serialVersionUID = 2852266759151L;
    protected String errcode;
    protected String errmsg;

    protected UncheckedException() {
    }

    protected UncheckedException(Throwable cause) {
        super(cause);
    }

    protected UncheckedException(String errmsg) {
        super(errmsg);
        this.errmsg = errmsg;
    }

    protected UncheckedException(Errors errors) {
        super(errors.getValue());
        this.errcode = errors.getKey();
        this.errmsg = errors.getValue();
    }

    public UncheckedException(Errors errors, String errmsg) {
        super(errmsg);
        this.errcode = errors.getKey();
        this.errmsg = errmsg;
    }

    protected UncheckedException(String errmsg, Throwable cause) {
        super(errmsg, cause);
        this.errmsg = errmsg;
    }

    protected UncheckedException(String errcode, String errmsg) {
        super(errmsg);
        this.errcode = errcode;
        this.errmsg = errmsg;
    }

    protected UncheckedException(String format, Object ... args) {
        super(String.format(format, args));
        this.errmsg = String.format(format, args);
    }

    protected UncheckedException(Throwable cause, String format, Object ... args) {
        super(String.format(format, args), cause);
        this.errmsg = String.format(format, args);
    }

    protected UncheckedException(String errmsg, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
        super(errmsg, cause, enableSuppression, writableStackTrace);
        this.errmsg = errmsg;
    }

    @Override
    public String getMessage() {
        if (this.errcode != null) {
            return this.errmsg;
        }
        return super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (this.errcode != null) {
            try {
                Locale locale = new Locale(I18n.AUTO_DETECT.lang());
                ResourceBundle bundle = ResourceBundle.getBundle("messages", locale);
                return bundle.getString(this.errcode);
            }
            catch (Exception e) {
                Errors.Entry entry = Errors.require(this.errcode);
                return entry != null ? entry.getValue() : this.getMessage();
            }
        }
        return super.getLocalizedMessage();
    }

    @Generated
    public String getErrcode() {
        return this.errcode;
    }

    @Generated
    public String getErrmsg() {
        return this.errmsg;
    }

    @Generated
    public void setErrcode(String errcode) {
        this.errcode = errcode;
    }

    @Generated
    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }
}

