/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.mutable;

import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.xyz.CompareKit;

public class MutableDouble
extends Number
implements Comparable<MutableDouble>,
Mutable<Number> {
    private static final long serialVersionUID = 2852270070171L;
    private double value;

    public MutableDouble() {
    }

    public MutableDouble(double value) {
        this.value = value;
    }

    public MutableDouble(Number value) {
        this(value.doubleValue());
    }

    public MutableDouble(String value) throws NumberFormatException {
        this.value = Double.parseDouble(value);
    }

    @Override
    public Double get() {
        return this.value;
    }

    @Override
    public void set(double value) {
        this.value = value;
    }

    @Override
    public void set(Number value) {
        this.value = value.doubleValue();
    }

    public MutableDouble increment() {
        this.value += 1.0;
        return this;
    }

    public MutableDouble decrement() {
        this.value -= 1.0;
        return this;
    }

    public MutableDouble add(double operand) {
        this.value += operand;
        return this;
    }

    public MutableDouble add(Number operand) {
        this.value += operand.doubleValue();
        return this;
    }

    public MutableDouble subtract(double operand) {
        this.value -= operand;
        return this;
    }

    public MutableDouble subtract(Number operand) {
        this.value -= operand.doubleValue();
        return this;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableDouble) {
            return Double.doubleToLongBits(((MutableDouble)object).value) == Double.doubleToLongBits(this.value);
        }
        return false;
    }

    public int hashCode() {
        return Double.hashCode(this.value);
    }

    @Override
    public int compareTo(MutableDouble other) {
        return CompareKit.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

