/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.mutable;

import org.miaixz.bus.core.lang.mutable.Mutable;
import org.miaixz.bus.core.xyz.CompareKit;

public class MutableShort
extends Number
implements Comparable<MutableShort>,
Mutable<Number> {
    private static final long serialVersionUID = 2852271712379L;
    private short value;

    public MutableShort() {
    }

    public MutableShort(short value) {
        this.value = value;
    }

    public MutableShort(Number value) {
        this(value.shortValue());
    }

    public MutableShort(String value) throws NumberFormatException {
        this.value = Short.parseShort(value);
    }

    @Override
    public Short get() {
        return this.value;
    }

    @Override
    public void set(short value) {
        this.value = value;
    }

    @Override
    public void set(Number value) {
        this.value = value.shortValue();
    }

    public MutableShort increment() {
        this.value = (short)(this.value + 1);
        return this;
    }

    public MutableShort decrement() {
        this.value = (short)(this.value - 1);
        return this;
    }

    public MutableShort add(short operand) {
        this.value = (short)(this.value + operand);
        return this;
    }

    public MutableShort add(Number operand) {
        this.value = (short)(this.value + operand.shortValue());
        return this;
    }

    public MutableShort subtract(short operand) {
        this.value = (short)(this.value - operand);
        return this;
    }

    public MutableShort subtract(Number operand) {
        this.value = (short)(this.value - operand.shortValue());
        return this;
    }

    @Override
    public short shortValue() {
        return this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object instanceof MutableShort) {
            return this.value == ((MutableShort)object).shortValue();
        }
        return false;
    }

    public int hashCode() {
        return this.value;
    }

    @Override
    public int compareTo(MutableShort other) {
        return CompareKit.compare(this.value, other.value);
    }

    public String toString() {
        return String.valueOf(this.value);
    }
}

