/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Map;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.convert.Convert;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.TypeKit;

public class ActualTypeMapper {
    private static final WeakConcurrentMap<Type, Map<Type, Type>> CACHE = new WeakConcurrentMap();

    public static Map<Type, Type> get(Type type) {
        return CACHE.computeIfAbsent(type, key -> ActualTypeMapper.createTypeMap(type));
    }

    public static Map<String, Type> getStringKeyMap(Type type) {
        return Convert.toMap(String.class, Type.class, ActualTypeMapper.get(type));
    }

    public static Type getActualType(Type type, TypeVariable<?> typeVariable) {
        Map<Type, Type> typeTypeMap = ActualTypeMapper.get(type);
        Type result = typeTypeMap.get(typeVariable);
        while (result instanceof TypeVariable) {
            result = typeTypeMap.get(result);
        }
        return result;
    }

    public static Type getActualType(Type type, GenericArrayType genericArrayType) {
        Type componentType;
        Map<Type, Type> typeTypeMap = ActualTypeMapper.get(type);
        Class<?> actualType = typeTypeMap.get(genericArrayType);
        if (actualType == null && (componentType = typeTypeMap.get(genericArrayType.getGenericComponentType())) instanceof Class) {
            actualType = ArrayKit.getArrayType((Class)componentType);
            typeTypeMap.put(genericArrayType, actualType);
        }
        return actualType;
    }

    public static Type[] getActualTypes(Type type, Type ... typeVariables) {
        Type[] result = new Type[typeVariables.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            result[i] = typeVariables[i] instanceof TypeVariable ? ActualTypeMapper.getActualType(type, (TypeVariable)typeVariables[i]) : typeVariables[i];
        }
        return result;
    }

    private static Map<Type, Type> createTypeMap(Type type) {
        ParameterizedType parameterizedType;
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (null != type && null != (parameterizedType = TypeKit.toParameterizedType(type))) {
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            Class rawType = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
            for (int i = 0; i < typeParameters.length; ++i) {
                Type value = typeArguments[i];
                if (value instanceof TypeVariable) continue;
                typeMap.put(typeParameters[i], value);
            }
            type = rawType;
        }
        return typeMap;
    }
}

