/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.reflect;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.xyz.ClassKit;

public class JdkProxy {
    public static <T> T newProxyInstance(ClassLoader classloader, InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return (T)Proxy.newProxyInstance(classloader, interfaces, invocationHandler);
    }

    public static <T> T newProxyInstance(InvocationHandler invocationHandler, Class<?> ... interfaces) {
        return JdkProxy.newProxyInstance(ClassKit.getClassLoader(), invocationHandler, interfaces);
    }

    public static boolean isProxy(Object object) {
        Assert.notNull(object);
        return JdkProxy.isProxyClass(object.getClass());
    }

    public static boolean isJdkProxy(Object object) {
        Assert.notNull(object);
        return JdkProxy.isJdkProxyClass(object.getClass());
    }

    public static boolean isCglibProxy(Object object) {
        Assert.notNull(object);
        return JdkProxy.isCglibProxyClass(object.getClass());
    }

    public static boolean isProxyClass(Class<?> clazz) {
        return JdkProxy.isJdkProxyClass(clazz) || JdkProxy.isCglibProxyClass(clazz);
    }

    public static boolean isJdkProxyClass(Class<?> clazz) {
        return Proxy.isProxyClass(Assert.notNull(clazz));
    }

    public static boolean isCglibProxyClass(Class<?> clazz) {
        return Assert.notNull(clazz).getName().contains("$$");
    }

    public static Class<?> getCglibActualClass(Class<?> clazz) {
        Class<?> actualClass = clazz;
        while (JdkProxy.isCglibProxyClass(actualClass)) {
            actualClass = actualClass.getSuperclass();
        }
        return actualClass;
    }
}

