/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.selector;

import java.util.ArrayList;
import java.util.List;
import org.miaixz.bus.core.lang.selector.Selector;
import org.miaixz.bus.core.lang.selector.SmoothWeightObject;
import org.miaixz.bus.core.lang.selector.WeightObject;
import org.miaixz.bus.core.xyz.CollKit;

public class SmoothWeightSelector<T>
implements Selector<T> {
    private final List<SmoothWeightObject<T>> objList = new ArrayList<SmoothWeightObject<T>>();

    public SmoothWeightSelector() {
    }

    public SmoothWeightSelector(Iterable<? extends WeightObject<T>> weightObjList) {
        this();
        for (WeightObject<T> weightObj : weightObjList) {
            this.add(weightObj);
        }
    }

    public static <T> SmoothWeightSelector<T> of() {
        return new SmoothWeightSelector<T>();
    }

    public SmoothWeightSelector<T> add(T object, int weight) {
        return this.add(new SmoothWeightObject<T>(object, weight));
    }

    public SmoothWeightSelector<T> add(WeightObject<T> weightObj) {
        SmoothWeightObject smoothWeightObj = weightObj instanceof SmoothWeightObject ? (SmoothWeightObject)weightObj : new SmoothWeightObject(weightObj.object, weightObj.weight);
        this.objList.add(smoothWeightObj);
        return this;
    }

    @Override
    public T select() {
        if (CollKit.isEmpty(this.objList)) {
            return null;
        }
        int totalWeight = 0;
        SmoothWeightObject<T> selected = null;
        for (SmoothWeightObject<T> object : this.objList) {
            totalWeight += object.getWeight();
            int currentWeight = object.getCurrentWeight() + object.getWeight();
            object.setCurrentWeight(currentWeight);
            if (null != selected && currentWeight <= selected.getCurrentWeight()) continue;
            selected = object;
        }
        if (null == selected) {
            return null;
        }
        selected.setCurrentWeight(selected.getCurrentWeight() - totalWeight);
        return selected.getObject();
    }
}

