/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.selector;

import java.io.Serializable;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.miaixz.bus.core.lang.selector.Selector;
import org.miaixz.bus.core.lang.selector.WeightObject;
import org.miaixz.bus.core.xyz.CollKit;

public class WeightRandomSelector<T>
implements Selector<T>,
Serializable {
    private static final long serialVersionUID = 2852278757903L;
    private final TreeMap<Integer, T> weightMap = new TreeMap();

    public WeightRandomSelector() {
    }

    public WeightRandomSelector(WeightObject<T> weightObj) {
        this();
        if (null != weightObj) {
            this.add(weightObj);
        }
    }

    public WeightRandomSelector(Iterable<WeightObject<T>> weightObjs) {
        this();
        if (CollKit.isNotEmpty(weightObjs)) {
            for (WeightObject<T> weightObj : weightObjs) {
                this.add(weightObj);
            }
        }
    }

    public WeightRandomSelector(WeightObject<T>[] weightObjs) {
        this();
        for (WeightObject<T> weightObj : weightObjs) {
            this.add(weightObj);
        }
    }

    public static <T> WeightRandomSelector<T> of() {
        return new WeightRandomSelector<T>();
    }

    public WeightRandomSelector<T> add(T object, int weight) {
        return this.add(new WeightObject<T>(object, weight));
    }

    public WeightRandomSelector<T> add(WeightObject<T> weightObj) {
        int weight;
        if (null != weightObj && (weight = weightObj.getWeight()) > 0) {
            int lastWeight = this.weightMap.isEmpty() ? 0 : this.weightMap.lastKey();
            this.weightMap.put(weight + lastWeight, weightObj.getObject());
        }
        return this;
    }

    public WeightRandomSelector<T> clear() {
        if (null != this.weightMap) {
            this.weightMap.clear();
        }
        return this;
    }

    @Override
    public T select() {
        int randomWeight = (int)((double)this.weightMap.lastKey().intValue() * Math.random());
        NavigableMap<Integer, T> tailMap = this.weightMap.tailMap(randomWeight, false);
        return this.weightMap.get(tailMap.firstKey());
    }
}

