/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.lang.tuple;

import java.util.Objects;
import org.miaixz.bus.core.lang.tuple.Pair;

public class Triplet<L, M, R>
extends Pair<L, R> {
    private static final long serialVersionUID = 2852281035663L;
    protected M middle;

    public Triplet(L left, M middle, R right) {
        super(left, right);
        this.middle = middle;
    }

    public static <L, M, R> Triplet<L, M, R> of(L left, M middle, R right) {
        return new Triplet<L, M, R>(left, middle, right);
    }

    public M getMiddle() {
        return this.middle;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Triplet) {
            Triplet triplet = (Triplet)o;
            return Objects.equals(this.getLeft(), triplet.getLeft()) && Objects.equals(this.getMiddle(), triplet.getMiddle()) && Objects.equals(this.getRight(), triplet.getRight());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left, this.middle, this.right);
    }

    @Override
    public String toString() {
        return "Triplet{left=" + String.valueOf(this.getLeft()) + ", middle=" + String.valueOf(this.getMiddle()) + ", right=" + String.valueOf(this.getRight()) + "}";
    }

    @Override
    public Triplet<L, M, R> clone() {
        return (Triplet)super.clone();
    }
}

