/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.math;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MathKit;

public class Arrangement
implements Serializable {
    private static final long serialVersionUID = 2852281592361L;
    private final String[] datas;

    public Arrangement(String[] datas) {
        this.datas = datas;
    }

    public static long count(int n) {
        return Arrangement.count(n, n);
    }

    public static long count(int n, int m) {
        if (n == m) {
            return MathKit.factorial(n);
        }
        return n > m ? MathKit.factorial(n, n - m) : 0L;
    }

    public static long countAll(int n) {
        long total = 0L;
        for (int i = 1; i <= n; ++i) {
            total += Arrangement.count(n, i);
        }
        return total;
    }

    public List<String[]> select() {
        return this.select(this.datas.length);
    }

    public List<String[]> select(int m) {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrangement.count(this.datas.length, m));
        this.select(this.datas, new String[m], 0, result);
        return result;
    }

    public List<String[]> selectAll() {
        ArrayList<String[]> result = new ArrayList<String[]>((int)Arrangement.countAll(this.datas.length));
        for (int i = 1; i <= this.datas.length; ++i) {
            result.addAll(this.select(i));
        }
        return result;
    }

    private void select(String[] datas, String[] resultList, int resultIndex, List<String[]> result) {
        if (resultIndex >= resultList.length) {
            if (!result.contains(resultList)) {
                result.add(Arrays.copyOf(resultList, resultList.length));
            }
            return;
        }
        for (int i = 0; i < datas.length; ++i) {
            resultList[resultIndex] = datas[i];
            this.select(ArrayKit.remove(datas, i), resultList, resultIndex + 1, result);
        }
    }
}

