/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.math;

import org.miaixz.bus.core.lang.Normal;
import org.miaixz.bus.core.xyz.MathKit;
import org.miaixz.bus.core.xyz.StringKit;

public class EnglishNumberFormatter {
    public static String format(Object x) {
        if (x != null) {
            return EnglishNumberFormatter.format(x.toString());
        }
        return "";
    }

    public static String formatSimple(long value) {
        return EnglishNumberFormatter.formatSimple(value, true);
    }

    public static String formatSimple(long number, boolean isCNUnit) {
        String suffix;
        double value;
        if (number < 1000L) {
            return String.valueOf(number);
        }
        if (number < 1000000L) {
            value = (double)number / 1000.0;
            suffix = "k";
        } else if (number < 1000000000L) {
            value = (double)number / 1000000.0;
            suffix = "m";
        } else if (number < 1000000000000L) {
            value = (double)number / 1.0E9;
            suffix = "b";
        } else {
            value = (double)number / 1.0E12;
            suffix = "t";
        }
        if (isCNUnit) {
            if ("m".equals(suffix)) {
                suffix = "w";
                value *= 100.0;
            } else if ("k".equals(suffix) && value >= 10.0) {
                suffix = "w";
                value /= 10.0;
            }
        }
        return MathKit.format("#.##", value) + suffix;
    }

    private static String format(String x) {
        Object xs;
        String lstr;
        int z = x.indexOf(".");
        String rstr = "";
        if (z > -1) {
            lstr = x.substring(0, z);
            rstr = x.substring(z + 1);
        } else {
            lstr = x;
        }
        Object lstrrev = StringKit.reverse(lstr);
        String[] a = new String[5];
        switch (((String)lstrrev).length() % 3) {
            case 1: {
                lstrrev = (String)lstrrev + "00";
                break;
            }
            case 2: {
                lstrrev = (String)lstrrev + "0";
            }
        }
        StringBuilder lm = new StringBuilder();
        for (int i = 0; i < ((String)lstrrev).length() / 3; ++i) {
            a[i] = StringKit.reverse(((String)lstrrev).substring(3 * i, 3 * i + 3));
            if (!"000".equals(a[i])) {
                if (i != 0) {
                    lm.insert(0, EnglishNumberFormatter.transThree(a[i]) + " " + EnglishNumberFormatter.parseMore(i) + " ");
                    continue;
                }
                lm = new StringBuilder(EnglishNumberFormatter.transThree(a[i]));
                continue;
            }
            lm.append(EnglishNumberFormatter.transThree(a[i]));
        }
        Object object = xs = lm.isEmpty() ? "ZERO " : " ";
        if (z > -1) {
            xs = (String)xs + "AND CENTS " + EnglishNumberFormatter.transTwo(rstr) + " ";
        }
        return lm.toString().trim() + (String)xs + "ONLY";
    }

    private static String parseTeen(String x) {
        return Normal.EN_NUMBER_TEEN[Integer.parseInt(x) - 10];
    }

    private static String parseTen(String x) {
        return Normal.EN_NUMBER_TEN[Integer.parseInt(x.substring(0, 1)) - 1];
    }

    private static String parseMore(int i) {
        return Normal.EN_NUMBER_MORE[i];
    }

    private static String transTwo(String x) {
        if (((String)x).length() > 2) {
            x = ((String)x).substring(0, 2);
        } else if (((String)x).length() < 2) {
            x = (String)x + "0";
        }
        Object value = ((String)x).startsWith("0") ? EnglishNumberFormatter.parseLast((String)x) : (((String)x).startsWith("1") ? EnglishNumberFormatter.parseTeen((String)x) : (((String)x).endsWith("0") ? EnglishNumberFormatter.parseTen((String)x) : EnglishNumberFormatter.parseTen((String)x) + " " + EnglishNumberFormatter.parseLast((String)x)));
        return value;
    }

    private static String transThree(String x) {
        Object value = x.startsWith("0") ? EnglishNumberFormatter.transTwo(x.substring(1)) : ("00".equals(x.substring(1)) ? EnglishNumberFormatter.parseLast(x.substring(0, 1)) + " HUNDRED" : EnglishNumberFormatter.parseLast(x.substring(0, 1)) + " HUNDRED AND " + EnglishNumberFormatter.transTwo(x.substring(1)));
        return value;
    }

    private static String parseLast(String s) {
        return Normal.EN_NUMBER[Integer.parseInt(s.substring(s.length() - 1))];
    }
}

