/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import java.io.Serializable;
import java.util.function.BiPredicate;
import org.miaixz.bus.core.xyz.StringKit;

public class OffsetMatcher
implements BiPredicate<CharSequence, CharSequence>,
Serializable {
    private static final long serialVersionUID = 2852233335568L;
    private final boolean ignoreCase;
    private final boolean ignoreEquals;
    private final int offset;

    public OffsetMatcher(boolean ignoreCase, boolean ignoreEquals, boolean isPrefix) {
        this(ignoreCase, ignoreEquals, isPrefix ? 0 : -1);
    }

    public OffsetMatcher(boolean ignoreCase, boolean ignoreEquals, int offset) {
        this.ignoreCase = ignoreCase;
        this.ignoreEquals = ignoreEquals;
        this.offset = offset;
    }

    @Override
    public boolean test(CharSequence text, CharSequence check) {
        if (null == text || null == check) {
            if (this.ignoreEquals) {
                return false;
            }
            return null == text && null == check;
        }
        int strToCheckLength = check.length();
        int toffset = this.offset >= 0 ? this.offset : text.length() - strToCheckLength + this.offset + 1;
        boolean matches = text.toString().regionMatches(this.ignoreCase, toffset, check.toString(), 0, strToCheckLength);
        if (matches) {
            return !this.ignoreEquals || !StringKit.equals(text, check, this.ignoreCase);
        }
        return false;
    }
}

