/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import java.util.Arrays;
import org.miaixz.bus.core.xyz.StringKit;

public class StringRepeater {
    private final int countOrLength;

    public StringRepeater(int countOrLength) {
        this.countOrLength = countOrLength;
    }

    public static StringRepeater of(int countOrLength) {
        return new StringRepeater(countOrLength);
    }

    public String repeat(char c) {
        int count = this.countOrLength;
        if (count <= 0) {
            return "";
        }
        char[] result = new char[count];
        Arrays.fill(result, c);
        return new String(result);
    }

    public String repeat(CharSequence text) {
        int n;
        if (null == text) {
            return null;
        }
        int count = this.countOrLength;
        if (count <= 0 || text.length() == 0) {
            return "";
        }
        if (count == 1) {
            return text.toString();
        }
        int len = text.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required String length is too large: " + longSize);
        }
        char[] array = new char[size];
        text.toString().getChars(0, len, array, 0);
        for (n = len; n < size - n; n <<= 1) {
            System.arraycopy(array, 0, array, n, n);
        }
        System.arraycopy(array, 0, array, n, size - n);
        return new String(array);
    }

    public String repeatByLength(CharSequence text) {
        if (null == text) {
            return null;
        }
        int padLen = this.countOrLength;
        if (padLen <= 0) {
            return "";
        }
        int strLen = text.length();
        if (strLen == padLen) {
            return text.toString();
        }
        if (strLen > padLen) {
            return StringKit.subPre(text, padLen);
        }
        char[] padding = new char[padLen];
        for (int i = 0; i < padLen; ++i) {
            padding[i] = text.charAt(i % strLen);
        }
        return new String(padding);
    }

    public String repeatAndJoin(CharSequence text, CharSequence delimiter) {
        int count = this.countOrLength;
        if (count <= 0) {
            return "";
        }
        if (StringKit.isEmpty(delimiter)) {
            return this.repeat(text);
        }
        StringBuilder builder = new StringBuilder(text.length() * count + delimiter.length() * (count - 1));
        builder.append(text);
        while (true) {
            int n = --count;
            --count;
            if (n <= 0) break;
            builder.append(delimiter).append(text);
        }
        return builder.toString();
    }
}

