/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text;

import java.io.Serializable;
import java.util.function.UnaryOperator;
import org.miaixz.bus.core.text.OffsetMatcher;
import org.miaixz.bus.core.xyz.StringKit;

public class StringStripper
implements UnaryOperator<CharSequence>,
Serializable {
    private static final long serialVersionUID = 2852233890053L;
    private final CharSequence prefix;
    private final CharSequence suffix;
    private final boolean ignoreCase;
    private final boolean stripAll;

    public StringStripper(CharSequence prefix, CharSequence suffix, boolean ignoreCase, boolean stripAll) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.ignoreCase = ignoreCase;
        this.stripAll = stripAll;
    }

    @Override
    public String apply(CharSequence charSequence) {
        return this.stripAll ? this.stripAll(charSequence) : this.stripOnce(charSequence);
    }

    private String stripOnce(CharSequence charSequence) {
        if (StringKit.isEmpty(charSequence)) {
            return StringKit.toStringOrNull(charSequence);
        }
        String str = charSequence.toString();
        int from = 0;
        int to = str.length();
        if (StringKit.isNotEmpty(this.prefix) && this.startWith(str, this.prefix, 0) && (from = this.prefix.length()) == to) {
            return "";
        }
        if (this.endWithSuffix(str)) {
            if (from == (to -= this.suffix.length())) {
                return "";
            }
            if (to < from) {
                to += this.suffix.length();
            }
        }
        return str.substring(from, to);
    }

    private String stripAll(CharSequence charSequence) {
        if (StringKit.isEmpty(charSequence)) {
            return StringKit.toStringOrNull(charSequence);
        }
        String str = charSequence.toString();
        int from = 0;
        int to = str.length();
        if (StringKit.isNotEmpty(this.prefix)) {
            while (this.startWith(str, this.prefix, from)) {
                if ((from += this.prefix.length()) != to) continue;
                return "";
            }
        }
        if (StringKit.isNotEmpty(this.suffix)) {
            int suffixLength = this.suffix.length();
            while (this.startWith(str, this.suffix, to - suffixLength)) {
                if (from == (to -= suffixLength)) {
                    return "";
                }
                if (to >= from) continue;
                to += suffixLength;
                break;
            }
        }
        return str.substring(from, to);
    }

    private boolean startWith(CharSequence charSequence, CharSequence strToCheck, int from) {
        return new OffsetMatcher(this.ignoreCase, false, from).test(charSequence, strToCheck);
    }

    private boolean endWithSuffix(CharSequence charSequence) {
        return StringKit.isNotEmpty(this.suffix) && StringKit.endWith(charSequence, this.suffix, this.ignoreCase);
    }
}

