/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.finder;

import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.text.finder.TextFinder;
import org.miaixz.bus.core.xyz.CharKit;

public class CharFinder
extends TextFinder {
    private static final long serialVersionUID = 2852236682062L;
    private final char c;
    private final boolean caseInsensitive;

    public CharFinder(char c) {
        this(c, false);
    }

    public CharFinder(char c, boolean caseInsensitive) {
        this.c = c;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int limit = this.getValidEndIndex();
        if (this.negative) {
            for (int i = from; i > limit; --i) {
                if (!CharKit.equals(this.c, this.text.charAt(i), this.caseInsensitive)) continue;
                return i;
            }
        } else {
            for (int i = from; i < limit; ++i) {
                if (!CharKit.equals(this.c, this.text.charAt(i), this.caseInsensitive)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + 1;
    }
}

