/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.placeholder;

import java.util.Map;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.lang.mutable.MutableEntry;
import org.miaixz.bus.core.text.placeholder.StringTemplate;
import org.miaixz.bus.core.text.placeholder.template.NamedPlaceholderString;
import org.miaixz.bus.core.text.placeholder.template.SinglePlaceholderString;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.StringKit;

public class StringFormatter {
    private static final WeakConcurrentMap<Map.Entry<CharSequence, Object>, StringTemplate> CACHE = new WeakConcurrentMap();

    public static String format(String strPattern, Object ... argArray) {
        return StringFormatter.formatWith(strPattern, "{}", argArray);
    }

    public static String formatWith(String strPattern, String placeHolder, Object ... argArray) {
        if (StringKit.isBlank(strPattern) || StringKit.isBlank(placeHolder) || ArrayKit.isEmpty(argArray)) {
            return strPattern;
        }
        return ((SinglePlaceholderString)CACHE.computeIfAbsent(MutableEntry.of(strPattern, placeHolder), k -> StringTemplate.of(strPattern).placeholder(placeHolder).build())).format(argArray);
    }

    public static String formatByBean(CharSequence template, Object bean, boolean ignoreNull) {
        if (null == template) {
            return null;
        }
        if (bean instanceof Map && MapKit.isEmpty((Map)bean)) {
            return template.toString();
        }
        return ((NamedPlaceholderString)CACHE.computeIfAbsent(MutableEntry.of(template, ignoreNull), k -> {
            NamedPlaceholderString.Builder builder = StringTemplate.ofNamed(template.toString());
            if (ignoreNull) {
                builder.addFeatures(new StringTemplate.Feature[]{StringTemplate.Feature.FORMAT_NULL_VALUE_TO_WHOLE_PLACEHOLDER});
            } else {
                builder.addFeatures(new StringTemplate.Feature[]{StringTemplate.Feature.FORMAT_NULL_VALUE_TO_EMPTY});
            }
            return builder.build();
        })).format(bean);
    }

    public static void clear() {
        CACHE.clear();
    }
}

