/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.replacer;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.miaixz.bus.core.text.replacer.StringReplacer;

public class HighMultiReplacer
extends StringReplacer {
    private static final long serialVersionUID = 2852238780005L;
    private final AhoCorasickAutomaton ahoCorasickAutomaton;

    public HighMultiReplacer(Map<String, Object> map) {
        this.ahoCorasickAutomaton = new AhoCorasickAutomaton(map);
    }

    public static HighMultiReplacer of(Map<String, Object> map) {
        return new HighMultiReplacer(map);
    }

    @Override
    public int replace(CharSequence text, int pos, StringBuilder out) {
        this.ahoCorasickAutomaton.replace(text, out);
        return text.length();
    }

    @Override
    public CharSequence apply(CharSequence text) {
        StringBuilder builder = new StringBuilder();
        this.replace(text, 0, builder);
        return builder;
    }

    private static class AhoCorasickAutomaton {
        private final Node root = new Node();
        private final Map<String, Object> target;

        public AhoCorasickAutomaton(Map<String, Object> target) {
            this.target = target;
            this.buildTrieTree();
            this.buildAcFromTrie();
        }

        private void buildTrieTree() {
            for (String text : this.target.keySet()) {
                if (text == null) continue;
                this.buildTrieTree(text, text);
                this.buildTrieTree("${" + text + "}", text);
                this.buildTrieTree("{" + text + "}", text);
            }
        }

        private void buildTrieTree(String pattern, String key) {
            Node curr = this.root;
            for (int i = 0; i < pattern.length(); ++i) {
                char ch = pattern.charAt(i);
                Node node = curr.children.get(Character.valueOf(ch));
                if (node == null) {
                    node = new Node();
                    curr.children.put(Character.valueOf(ch), node);
                }
                curr = node;
            }
            curr.text = key;
        }

        private void buildAcFromTrie() {
            LinkedList<Node> queue = new LinkedList<Node>();
            for (Node x : this.root.children.values()) {
                x.fail = this.root;
                queue.addLast(x);
            }
            while (!queue.isEmpty()) {
                Node p = (Node)queue.removeFirst();
                block2: for (Map.Entry<Character, Node> entry : p.children.entrySet()) {
                    queue.addLast(entry.getValue());
                    Node failTo = p.fail;
                    while (true) {
                        if (failTo == null) {
                            entry.getValue().fail = this.root;
                            continue block2;
                        }
                        if (failTo.children.get(entry.getKey()) != null) {
                            entry.getValue().fail = failTo.children.get(entry.getKey());
                            continue block2;
                        }
                        failTo = failTo.fail;
                    }
                }
            }
        }

        public void replace(CharSequence text, StringBuilder stringBuilder) {
            Node curr = this.root;
            int i = 0;
            while (i < text.length()) {
                char ch = text.charAt(i);
                Node node = curr.children.get(Character.valueOf(ch));
                if (node != null) {
                    curr = node;
                    if (curr.isWord()) {
                        Object replacement = this.target.get(curr.text);
                        stringBuilder.append(replacement != null ? replacement : "");
                        curr = this.root;
                    }
                    ++i;
                    continue;
                }
                if (curr != this.root) {
                    curr = curr.fail;
                    continue;
                }
                stringBuilder.append(ch);
                ++i;
            }
        }

        private static class Node {
            String text;
            Map<Character, Node> children = new HashMap<Character, Node>();
            Node fail;

            private Node() {
            }

            public boolean isWord() {
                return this.text != null;
            }
        }
    }
}

