/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.text.replacer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.miaixz.bus.core.text.replacer.StringReplacer;

public class LookupReplacer
extends StringReplacer {
    private static final long serialVersionUID = 2852239213366L;
    private final Map<String, String> lookupMap;
    private final Set<Character> keyPrefixSkeyet;
    private final int minLength;
    private final int maxLength;

    public LookupReplacer(String[] ... lookup) {
        this.lookupMap = new HashMap<String, String>(lookup.length, 1.0f);
        this.keyPrefixSkeyet = new HashSet<Character>(lookup.length, 1.0f);
        int minLength = Integer.MAX_VALUE;
        int maxLength = 0;
        for (String[] pair : lookup) {
            String key = pair[0];
            this.lookupMap.put(key, pair[1]);
            this.keyPrefixSkeyet.add(Character.valueOf(key.charAt(0)));
            int keySize = key.length();
            if (keySize > maxLength) {
                maxLength = keySize;
            }
            if (keySize >= minLength) continue;
            minLength = keySize;
        }
        this.maxLength = maxLength;
        this.minLength = minLength;
    }

    @Override
    protected int replace(CharSequence text, int pos, StringBuilder out) {
        if (this.keyPrefixSkeyet.contains(Character.valueOf(text.charAt(pos)))) {
            int max = this.maxLength;
            if (pos + this.maxLength > text.length()) {
                max = text.length() - pos;
            }
            for (int i = max; i >= this.minLength; --i) {
                CharSequence subSeq = text.subSequence(pos, pos + i);
                String result = this.lookupMap.get(subSeq.toString());
                if (null == result) continue;
                out.append(result);
                return i;
            }
        }
        return 0;
    }
}

