/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.function.BiConsumerX;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.center.function.FunctionX;
import org.miaixz.bus.core.center.function.PredicateX;
import org.miaixz.bus.core.center.stream.EasyStream;
import org.miaixz.bus.core.lang.Optional;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ListKit;

public class BeanTree<T, R extends Comparable<R>> {
    private final FunctionX<T, R> idGetter;
    private final FunctionX<T, R> pidGetter;
    private final R pidValue;
    private final PredicateX<T> parentPredicate;
    private final FunctionX<T, List<T>> childrenGetter;
    private final BiConsumerX<T, List<T>> childrenSetter;

    private BeanTree(FunctionX<T, R> idGetter, FunctionX<T, R> pidGetter, R pidValue, PredicateX<T> parentPredicate, FunctionX<T, List<T>> childrenGetter, BiConsumerX<T, List<T>> childrenSetter) {
        this.idGetter = Objects.requireNonNull(idGetter, "idGetter must not be null");
        this.pidGetter = Objects.requireNonNull(pidGetter, "pidGetter must not be null");
        this.pidValue = pidValue;
        this.parentPredicate = parentPredicate;
        this.childrenGetter = Objects.requireNonNull(childrenGetter, "childrenGetter must not be null");
        this.childrenSetter = Objects.requireNonNull(childrenSetter, "childrenSetter must not be null");
    }

    public static <T, R extends Comparable<R>> BeanTree<T, R> of(FunctionX<T, R> idGetter, FunctionX<T, R> pidGetter, R pidValue, FunctionX<T, List<T>> childrenGetter, BiConsumerX<T, List<T>> childrenSetter) {
        return new BeanTree<T, R>(idGetter, pidGetter, pidValue, null, childrenGetter, childrenSetter);
    }

    public static <T, R extends Comparable<R>> BeanTree<T, R> ofMatch(FunctionX<T, R> idGetter, FunctionX<T, R> pidGetter, PredicateX<T> parentPredicate, FunctionX<T, List<T>> childrenGetter, BiConsumerX<T, List<T>> childrenSetter) {
        return new BeanTree<T, Object>(idGetter, pidGetter, null, Objects.requireNonNull(parentPredicate, "parentPredicate must not be null"), childrenGetter, childrenSetter);
    }

    public List<T> toTree(List<T> list) {
        if (CollKit.isEmpty(list)) {
            return ListKit.zero();
        }
        if (Objects.isNull(this.parentPredicate)) {
            Map<R, List<T>> pIdValuesMap = ((EasyStream)EasyStream.of(list).peek(e -> Objects.requireNonNull((Comparable)this.idGetter.apply(e), () -> "The data of tree node must not be null " + String.valueOf(e)))).group(this.pidGetter);
            List parents = pIdValuesMap.getOrDefault(this.pidValue, new ArrayList());
            this.findChildren(list, pIdValuesMap);
            return parents;
        }
        ArrayList parents = new ArrayList();
        Map<R, List<T>> pIdValuesMap = ((EasyStream)EasyStream.of(list).peek(e -> {
            if (this.parentPredicate.test(e)) {
                parents.add(e);
            }
            Objects.requireNonNull((Comparable)this.idGetter.apply(e));
        })).group(this.pidGetter);
        this.findChildren(list, pIdValuesMap);
        return parents;
    }

    public List<T> flat(List<T> tree) {
        AtomicReference<Function<Object, EasyStream>> recursiveRef = new AtomicReference<Function<Object, EasyStream>>();
        Function<Object, EasyStream> recursive = e -> (EasyStream)EasyStream.of((Iterable)this.childrenGetter.apply(e)).flat((Function)recursiveRef.get()).unshift(e);
        recursiveRef.set(recursive);
        return ((EasyStream)EasyStream.of(tree).flat(recursive).peek(e -> this.childrenSetter.accept(e, null))).toList();
    }

    public List<T> filter(List<T> tree, PredicateX<T> condition) {
        Objects.requireNonNull(condition, "filter condition must be not null");
        AtomicReference recursiveRef = new AtomicReference();
        PredicateX[] predicateXArray = new PredicateX[2];
        predicateXArray[0] = condition::test;
        predicateXArray[1] = e -> Optional.ofEmptyAble(this.childrenGetter.apply(e)).map(children -> ((EasyStream)EasyStream.of(children).filter((Predicate)recursiveRef.get())).toList()).ifPresent(children -> this.childrenSetter.accept(e, (List<Object>)children)).filter(s -> !s.isEmpty()).isPresent();
        PredicateX recursive = PredicateX.multiOr(predicateXArray);
        recursiveRef.set(recursive);
        return ((EasyStream)EasyStream.of(tree).filter((Predicate)recursive)).toList();
    }

    public List<T> forEach(List<T> tree, ConsumerX<T> action) {
        Objects.requireNonNull(action, "action must be not null");
        AtomicReference recursiveRef = new AtomicReference();
        ConsumerX[] consumerXArray = new ConsumerX[2];
        consumerXArray[0] = action::accept;
        consumerXArray[1] = e -> Optional.ofEmptyAble(this.childrenGetter.apply(e)).ifPresent(children -> EasyStream.of(children).forEach((Consumer)recursiveRef.get()));
        ConsumerX recursive = ConsumerX.multi(consumerXArray);
        recursiveRef.set(recursive);
        EasyStream.of(tree).forEach(recursive);
        return tree;
    }

    private void findChildren(List<T> list, Map<R, List<T>> pIdValuesMap) {
        for (T node : list) {
            List<T> children = pIdValuesMap.get(this.idGetter.apply(node));
            if (children == null) continue;
            this.childrenSetter.accept(node, children);
        }
    }
}

