/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xml;

import java.util.HashMap;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import org.miaixz.bus.core.center.map.BiMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UniversalNamespace
implements NamespaceContext {
    private static final String DEFAULT_NS = "DEFAULT";
    private final BiMap<String, String> prefixUri = new BiMap(new HashMap());

    public UniversalNamespace(Node node, boolean toplevelOnly) {
        this.examineNode(node.getFirstChild(), toplevelOnly);
    }

    private void examineNode(Node node, boolean attributesOnly) {
        NodeList childNodes;
        NamedNodeMap attributes = node.getAttributes();
        if (null != attributes) {
            int length = attributes.getLength();
            for (int i = 0; i < length; ++i) {
                Node attribute = attributes.item(i);
                this.storeAttribute(attribute);
            }
        }
        if (!attributesOnly && null != (childNodes = node.getChildNodes())) {
            int childLength = childNodes.getLength();
            for (int i = 0; i < childLength; ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                this.examineNode(item, false);
            }
        }
    }

    private void storeAttribute(Node node) {
        if (null == node) {
            return;
        }
        if ("http://www.w3.org/2000/xmlns/".equals(node.getNamespaceURI())) {
            if ("xmlns".equals(node.getNodeName())) {
                this.prefixUri.put(DEFAULT_NS, node.getNodeValue());
            } else {
                this.prefixUri.put(node.getLocalName(), node.getNodeValue());
            }
        }
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null || "".equals(prefix)) {
            return (String)this.prefixUri.get(DEFAULT_NS);
        }
        return (String)this.prefixUri.get(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.prefixUri.getInverse().get(namespaceURI);
    }

    @Override
    public Iterator<String> getPrefixes(String namespaceURI) {
        return null;
    }
}

