/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.Date;
import org.miaixz.bus.core.center.date.DateTime;
import org.miaixz.bus.core.data.CIN;
import org.miaixz.bus.core.data.CIN10;
import org.miaixz.bus.core.xyz.DateKit;
import org.miaixz.bus.core.xyz.StringKit;

public class CitizenIdKit {
    public static String convert15To18(String idCard) {
        return CIN.convert15To18(idCard);
    }

    public static String convert18To15(String idCard) {
        return CIN.convert18To15(idCard);
    }

    public static boolean isValidCard(String idCard) {
        if (StringKit.isBlank(idCard)) {
            return false;
        }
        int length = idCard.length();
        switch (length) {
            case 18: {
                return CitizenIdKit.isValidCard18(idCard);
            }
            case 15: {
                try {
                    return CitizenIdKit.isValidCard18(CIN.convert15To18(idCard));
                }
                catch (Exception ignore) {
                    return false;
                }
            }
            case 10: {
                return CitizenIdKit.isValidCard10(idCard);
            }
        }
        return false;
    }

    public static boolean isValidCard18(String idcard) {
        return CitizenIdKit.isValidCard18(idcard, true);
    }

    public static boolean isValidCard18(String idcard, boolean ignoreCase) {
        return CIN.verify(idcard, ignoreCase);
    }

    public static boolean isValidCard10(String idcard) {
        try {
            return CIN10.of(idcard).isVerified();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String getBirth(String idCard) {
        return CitizenIdKit.getCIN(idCard).getBirth();
    }

    public static DateTime getBirthDate(String idCard) {
        return CitizenIdKit.getCIN(idCard).getBirthDate();
    }

    public static int getAge(String idcard) {
        return CitizenIdKit.getAge(idcard, DateKit.now());
    }

    public static int getAge(String idcard, Date dateToCompare) {
        return DateKit.age(CitizenIdKit.getBirthDate(idcard), dateToCompare);
    }

    public static Short getBirthYear(String idcard) {
        return CitizenIdKit.getCIN(idcard).getBirthYear();
    }

    public static Short getBirthMonth(String idcard) {
        return CitizenIdKit.getCIN(idcard).getBirthMonth();
    }

    public static Short getBirthDay(String idcard) {
        return CitizenIdKit.getCIN(idcard).getBirthDay();
    }

    public static int getGender(String idcard) {
        return CitizenIdKit.getCIN(idcard).getGender();
    }

    public static String getProvinceCode(String idcard) {
        return CitizenIdKit.getCIN(idcard).getProvinceCode();
    }

    public static String getProvince(String idcard) {
        return CitizenIdKit.getCIN(idcard).getProvince();
    }

    public static String getCityCode(String idcard) {
        return CitizenIdKit.getCIN(idcard).getCityCode();
    }

    public static String getDistrictCode(String idcard) {
        return CitizenIdKit.getCIN(idcard).getDistrictCode();
    }

    public static String hide(String idcard, int startInclude, int endExclude) {
        return StringKit.hide(idcard, startInclude, endExclude);
    }

    public static CIN getCIN(String idcard) {
        return CIN.of(idcard);
    }

    public static boolean isValidHkMoHomeReturn(String idCard) {
        if (StringKit.isEmpty(idCard)) {
            return false;
        }
        String reg = "^[HhMm](\\d{8}|\\d{10})$";
        return idCard.matches("^[HhMm](\\d{8}|\\d{10})$");
    }
}

