/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.map.reference.WeakConcurrentMap;
import org.miaixz.bus.core.convert.CompositeConverter;
import org.miaixz.bus.core.convert.Converter;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.annotation.Alias;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.lang.reflect.field.FieldInvoker;
import org.miaixz.bus.core.lang.reflect.field.FieldReflect;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.MapKit;
import org.miaixz.bus.core.xyz.ObjectKit;
import org.miaixz.bus.core.xyz.ReflectKit;
import org.miaixz.bus.core.xyz.StringKit;

public class FieldKit {
    private static final WeakConcurrentMap<Class<?>, FieldReflect> FIELDS_CACHE = new WeakConcurrentMap();

    static synchronized void clearCache() {
        FIELDS_CACHE.clear();
    }

    public static boolean isOuterClassField(Field field) {
        return "this$0".equals(field.getName());
    }

    public static boolean hasField(Class<?> beanClass, String name) throws SecurityException {
        return null != FieldKit.getField(beanClass, name);
    }

    public static String getFieldName(Field field) {
        return FieldKit.getFieldName(field, true);
    }

    public static String getFieldName(Field field, boolean useAlias) {
        Alias alias;
        if (null == field) {
            return null;
        }
        if (useAlias && null != (alias = field.getAnnotation(Alias.class))) {
            return alias.value();
        }
        return field.getName();
    }

    public static Field getDeclaredField(Class<?> beanClass, String name) {
        Field[] fields = FieldKit.getDeclaredFields(beanClass, field -> StringKit.equals(name, field.getName()));
        return ArrayKit.isEmpty(fields) ? null : fields[0];
    }

    public static Field getField(Class<?> beanClass, String name) throws SecurityException {
        Field[] fields = FieldKit.getFields(beanClass, field -> StringKit.equals(name, field.getName()));
        return ArrayKit.isEmpty(fields) ? null : fields[0];
    }

    public static Map<String, Field> getFieldMap(Class<?> beanClass) {
        Field[] fields = FieldKit.getFields(beanClass);
        HashMap<String, Field> map = MapKit.newHashMap(fields.length, true);
        for (Field field : fields) {
            map.putIfAbsent(field.getName(), field);
        }
        return map;
    }

    public static Field[] getFields(Class<?> beanClass) throws SecurityException {
        return FieldKit.getFields(beanClass, null);
    }

    public static Field[] getFields(Class<?> beanClass, Predicate<Field> filter) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getAllFields(filter);
    }

    public static Field[] getDeclaredFields(Class<?> beanClass, Predicate<Field> filter) throws SecurityException {
        Assert.notNull(beanClass);
        return FIELDS_CACHE.computeIfAbsent(beanClass, FieldReflect::of).getDeclaredFields(filter);
    }

    public static Field[] getFieldsDirectly(Class<?> beanClass, boolean withSuperClassFields) throws SecurityException {
        return FieldReflect.of(beanClass).getFieldsDirectly(withSuperClassFields);
    }

    public static Object getFieldValue(Object object, String fieldName) throws InternalException {
        if (null == object || StringKit.isBlank(fieldName)) {
            return null;
        }
        return FieldKit.getFieldValue(object, FieldKit.getField(object instanceof Class ? (Class<?>)object : object.getClass(), fieldName));
    }

    public static Object getStaticFieldValue(Field field) throws InternalException {
        return FieldKit.getFieldValue(null, field);
    }

    public static Object getFieldValue(Object object, Field field) throws InternalException {
        Object result;
        if (null == field) {
            return null;
        }
        if (object instanceof Class) {
            object = null;
        }
        ReflectKit.setAccessible(field);
        try {
            result = field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(e, "IllegalAccess for {}.{}", field.getDeclaringClass(), field.getName());
        }
        return result;
    }

    public static Object[] getFieldsValue(Object object) {
        return FieldKit.getFieldsValue(object, null);
    }

    public static Object[] getFieldsValue(Object object, Predicate<Field> filter) {
        Field[] fields;
        if (null != object && null != (fields = FieldKit.getFields(object instanceof Class ? (Class<?>)object : object.getClass(), filter))) {
            return ArrayKit.mapToArray(fields, field -> FieldKit.getFieldValue(object, field), Object[]::new);
        }
        return null;
    }

    public static Object getFieldsAndValue(Object object) {
        Field[] fields;
        if (null != object && null != (fields = FieldKit.getFields(object instanceof Class ? (Class<?>)object : object.getClass()))) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields) {
                Object obj = FieldKit.getFieldValue(object, field);
                if (!ObjectKit.isNotEmpty(obj) || FieldKit.isSerialVersionUID(field)) continue;
                map.put(field.getName(), FieldKit.getFieldValue(object, field));
            }
            return map;
        }
        return null;
    }

    public static Object getFieldsAndValue(Object object, Predicate<Field> filter) {
        Field[] fields;
        if (null != object && null != (fields = FieldKit.getFields(object instanceof Class ? (Class<?>)object : object.getClass(), filter))) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : fields) {
                Object obj = FieldKit.getFieldValue(object, field);
                if (!ObjectKit.isNotEmpty(obj) || FieldKit.isSerialVersionUID(field)) continue;
                map.put(field.getName(), FieldKit.getFieldValue(object, field));
            }
            return map;
        }
        return null;
    }

    public static void setFieldValue(Object object, String fieldName, Object value) throws InternalException {
        Assert.notNull(object, "Object must be not null !", new Object[0]);
        Assert.notBlank(fieldName);
        Field field = FieldKit.getField(object instanceof Class ? (Class<?>)object : object.getClass(), fieldName);
        Assert.notNull(field, "Field [{}] is not exist in [{}]", fieldName, object.getClass().getName());
        FieldKit.setFieldValue(object, field, value);
    }

    public static void setStaticFieldValue(Field field, Object value) throws InternalException {
        FieldKit.setFieldValue(null, field, value);
    }

    public static void setFieldValue(Object object, Field field, Object value) throws InternalException {
        FieldKit.setFieldValue(object, field, value, CompositeConverter.getInstance());
    }

    public static void setFieldValue(Object object, Field field, Object value, Converter converter) throws InternalException {
        Assert.notNull(field, "Field in [{}] not exist !", object);
        FieldInvoker.of(field).setConverter(converter).invokeSet(object, value);
    }

    public static boolean isSerialVersionUID(Field field) {
        return "serialVersionUID".equals(field.getName()) && (Long.class.equals(field.getType()) || Long.TYPE.equals(field.getType())) && field.getModifiers() == 26;
    }
}

