/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;
import org.miaixz.bus.core.center.function.ConsumerX;
import org.miaixz.bus.core.center.iterator.LineIterator;
import org.miaixz.bus.core.io.BomReader;
import org.miaixz.bus.core.io.LifeCycle;
import org.miaixz.bus.core.io.SectionBuffer;
import org.miaixz.bus.core.io.StreamProgress;
import org.miaixz.bus.core.io.buffer.Buffer;
import org.miaixz.bus.core.io.copier.ChannelCopier;
import org.miaixz.bus.core.io.copier.FileChannelCopier;
import org.miaixz.bus.core.io.copier.ReaderWriterCopier;
import org.miaixz.bus.core.io.copier.StreamCopier;
import org.miaixz.bus.core.io.sink.BufferSink;
import org.miaixz.bus.core.io.sink.RealSink;
import org.miaixz.bus.core.io.sink.Sink;
import org.miaixz.bus.core.io.source.BufferSource;
import org.miaixz.bus.core.io.source.RealSource;
import org.miaixz.bus.core.io.source.Source;
import org.miaixz.bus.core.io.stream.FastByteArrayOutputStream;
import org.miaixz.bus.core.io.stream.StreamReader;
import org.miaixz.bus.core.io.stream.StreamWriter;
import org.miaixz.bus.core.io.timout.AsyncTimeout;
import org.miaixz.bus.core.io.timout.Timeout;
import org.miaixz.bus.core.lang.Assert;
import org.miaixz.bus.core.lang.Console;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ByteKit;
import org.miaixz.bus.core.xyz.HexKit;
import org.miaixz.bus.core.xyz.ResourceKit;
import org.miaixz.bus.core.xyz.StringKit;

public class IoKit {
    public static long copy(Reader reader, Writer writer) throws InternalException {
        return IoKit.copy(reader, writer, 8192);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize) throws InternalException {
        return IoKit.copy(reader, writer, bufferSize, null);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, StreamProgress streamProgress) throws InternalException {
        return IoKit.copy(reader, writer, bufferSize, -1L, streamProgress);
    }

    public static long copy(Reader reader, Writer writer, int bufferSize, long count, StreamProgress streamProgress) throws InternalException {
        Assert.notNull(reader, "Reader is null !", new Object[0]);
        Assert.notNull(writer, "Writer is null !", new Object[0]);
        return new ReaderWriterCopier(bufferSize, count, streamProgress).copy(reader, writer);
    }

    public static long copy(InputStream in, OutputStream out) throws InternalException {
        return IoKit.copy(in, out, 8192);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize) throws InternalException {
        return IoKit.copy(in, out, bufferSize, (StreamProgress)null);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws InternalException {
        return IoKit.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws InternalException {
        Assert.notNull(in, "InputStream is null !", new Object[0]);
        Assert.notNull(out, "OutputStream is null !", new Object[0]);
        return new StreamCopier(bufferSize, count, streamProgress).copy(in, out);
    }

    public static long copy(FileInputStream in, FileOutputStream out) throws InternalException {
        Assert.notNull(in, "FileInputStream is null!", new Object[0]);
        Assert.notNull(out, "FileOutputStream is null!", new Object[0]);
        return FileChannelCopier.of().copy(in, out);
    }

    public static void copy(InputStream in, OutputStream out, byte[] buffer) throws IOException {
        int count;
        while ((count = in.read(buffer, 0, buffer.length)) > 0) {
            if (out == null) continue;
            out.write(buffer, 0, count);
        }
    }

    public static void copy(InputStream in, OutputStream out, int len, int swapBytes) throws InternalException {
        IoKit.copy(in, out, (long)len & 0xFFFFFFFFL, swapBytes);
    }

    public static void copy(InputStream in, OutputStream out, long len, int swapBytes) throws InternalException {
        IoKit.copy(in, out, len, swapBytes, new byte[(int)Math.min(len, 4096L)]);
    }

    public static void copy(InputStream in, OutputStream out, long bufferSize) throws InternalException {
        IoKit.copy(in, out, bufferSize & 0xFFFFFFFFL, new byte[(int)Math.min(bufferSize, 4096L)]);
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize, byte[] buffer) throws InternalException {
        IoKit.copy(in, out, (long)bufferSize & 0xFFFFFFFFL, buffer);
    }

    public static void copy(InputStream in, OutputStream out, long bufferSize, byte[] buffer) throws InternalException {
        if (bufferSize < 0L) {
            throw new IndexOutOfBoundsException();
        }
        try {
            while (bufferSize > 0L) {
                int count = in.read(buffer, 0, (int)Math.min(bufferSize, (long)buffer.length));
                if (count < 0) {
                    throw new InternalException();
                }
                out.write(buffer, 0, count);
                bufferSize -= (long)count;
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static void copy(InputStream in, OutputStream out, int bufferSize, int swapBytes, byte[] buffer) throws InternalException {
        IoKit.copy(in, out, (long)bufferSize & 0xFFFFFFFFL, swapBytes, buffer);
    }

    public static void copy(InputStream in, OutputStream out, long bufferSize, int swapBytes, byte[] buffer) throws InternalException {
        if (swapBytes == 1) {
            IoKit.copy(in, out, bufferSize, buffer);
            return;
        }
        if (swapBytes != 2 && swapBytes != 4) {
            throw new IllegalArgumentException("swapBytes: " + swapBytes);
        }
        if (bufferSize < 0L || bufferSize % (long)swapBytes != 0L) {
            throw new IllegalArgumentException("length: " + bufferSize);
        }
        int off = 0;
        try {
            while (bufferSize > 0L) {
                int count = in.read(buffer, off, (int)Math.min(bufferSize, (long)(buffer.length - off)));
                if (count < 0) {
                    throw new InternalException("" + count);
                }
                bufferSize -= (long)count;
                off = (count += off) % swapBytes;
                count -= off;
                switch (swapBytes) {
                    case 2: {
                        ByteKit.swapShorts(buffer, 0, count);
                        break;
                    }
                    case 4: {
                        ByteKit.swapInts(buffer, 0, count);
                        break;
                    }
                    case 8: {
                        ByteKit.swapLongs(buffer, 0, count);
                    }
                }
                out.write(buffer, 0, count);
                if (off <= 0) continue;
                System.arraycopy(buffer, count, buffer, 0, off);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static BufferedReader toUtf8Reader(InputStream in) {
        return IoKit.toReader(in, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static BomReader toBomReader(InputStream in) {
        return new BomReader(in);
    }

    public static BufferedReader toReader(InputStream in, Charset charset) {
        if (null == in) {
            return null;
        }
        InputStreamReader reader = null == charset ? new InputStreamReader(in) : new InputStreamReader(in, charset);
        return new BufferedReader(reader);
    }

    public static OutputStreamWriter toUtf8Writer(OutputStream out) {
        return IoKit.toWriter(out, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static OutputStreamWriter toWriter(OutputStream out, Charset charset) {
        if (null == out) {
            return null;
        }
        if (null == charset) {
            return new OutputStreamWriter(out);
        }
        return new OutputStreamWriter(out, charset);
    }

    public static String readUtf8(InputStream in) throws InternalException {
        return IoKit.read(in, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String read(InputStream in, Charset charset) throws InternalException {
        return StringKit.toString(IoKit.readBytes(in), charset);
    }

    public static FastByteArrayOutputStream read(InputStream in) throws InternalException {
        return IoKit.read(in, true);
    }

    public static FastByteArrayOutputStream read(InputStream in, boolean isClose) throws InternalException {
        return StreamReader.of(in, isClose).read();
    }

    public static String read(Reader reader) throws InternalException {
        return IoKit.read(reader, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String read(Reader reader, boolean isClose) throws InternalException {
        StringBuilder builder = StringKit.builder();
        CharBuffer buffer = CharBuffer.allocate(8192);
        try {
            while (-1 != reader.read(buffer)) {
                builder.append(buffer.flip());
            }
            if (!isClose) return builder.toString();
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                if (!isClose) throw throwable;
                IoKit.closeQuietly(reader);
                throw throwable;
            }
        }
        IoKit.closeQuietly(reader);
        return builder.toString();
    }

    public static byte[] readBytes(InputStream in) throws InternalException {
        return IoKit.readBytes(in, true);
    }

    public static byte[] readBytes(InputStream in, boolean isClose) throws InternalException {
        return StreamReader.of(in, isClose).readBytes();
    }

    public static byte[] readBytes(InputStream in, int length) throws InternalException {
        return StreamReader.of(in, false).readBytes(length);
    }

    public static String readHex(InputStream in, int length, boolean toLowerCase) throws InternalException {
        return HexKit.encodeString(IoKit.readBytes(in, length), toLowerCase);
    }

    public static <T> T readObject(InputStream in, Class<?> ... acceptClasses) throws InternalException {
        return StreamReader.of(in, false).readObject(acceptClasses);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, T collection) throws InternalException {
        return IoKit.readLines(in, org.miaixz.bus.core.lang.Charset.UTF_8, collection);
    }

    public static <T extends Collection<String>> T readLines(InputStream in, Charset charset, T collection) throws InternalException {
        return IoKit.readLines((Reader)IoKit.toReader(in, charset), collection);
    }

    public static <T extends Collection<String>> T readLines(Reader reader, T collection) throws InternalException {
        IoKit.readLines(reader, collection::add);
        return collection;
    }

    public static void readLines(InputStream in, ConsumerX<String> lineHandler) throws InternalException {
        IoKit.readLines(in, org.miaixz.bus.core.lang.Charset.UTF_8, lineHandler);
    }

    public static void readLines(InputStream in, Charset charset, ConsumerX<String> lineHandler) throws InternalException {
        IoKit.readLines((Reader)IoKit.toReader(in, charset), lineHandler);
    }

    public static void readLines(Reader reader, ConsumerX<String> lineHandler) throws InternalException {
        Assert.notNull(reader);
        Assert.notNull(lineHandler);
        for (String line : IoKit.lineIter(reader)) {
            lineHandler.accept(line);
        }
    }

    public static FastByteArrayOutputStream readToToken(InputStream in, int token) {
        return IoKit.readTo(in, c -> c == token);
    }

    public static FastByteArrayOutputStream readTo(InputStream in, Predicate<Integer> predicate) {
        return StreamReader.of(in, false).readTo(predicate);
    }

    public static ByteArrayInputStream toStream(String content) {
        return IoKit.toStream(content, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static ByteArrayInputStream toStream(String content, Charset charset) {
        if (content == null) {
            return null;
        }
        return IoKit.toStream(ByteKit.toBytes(content, charset));
    }

    public static InputStream toStream(File file) {
        Assert.notNull(file);
        return IoKit.toStream(file.toPath());
    }

    public static InputStream toStream(Path path) {
        Assert.notNull(path);
        try {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static ByteArrayInputStream toStream(byte[] content) {
        if (content == null) {
            return null;
        }
        return new ByteArrayInputStream(content);
    }

    public static ByteArrayInputStream toStream(ByteArrayOutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static ByteArrayInputStream toStream(FastByteArrayOutputStream out) {
        if (out == null) {
            return null;
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public static BufferedInputStream toBuffered(InputStream in) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in);
    }

    public static BufferedInputStream toBuffered(InputStream in, int bufferSize) {
        Assert.notNull(in, "InputStream must be not null!", new Object[0]);
        return in instanceof BufferedInputStream ? (BufferedInputStream)in : new BufferedInputStream(in, bufferSize);
    }

    public static BufferedOutputStream toBuffered(OutputStream out) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out);
    }

    public static BufferedOutputStream toBuffered(OutputStream out, int bufferSize) {
        Assert.notNull(out, "OutputStream must be not null!", new Object[0]);
        return out instanceof BufferedOutputStream ? (BufferedOutputStream)out : new BufferedOutputStream(out, bufferSize);
    }

    public static BufferedReader toBuffered(Reader reader) {
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    public static BufferedReader toBuffered(Reader reader, int bufferSize) {
        Assert.notNull(reader, "Reader must be not null!", new Object[0]);
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, bufferSize);
    }

    public static BufferedWriter toBuffered(Writer writer) {
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
    }

    public static BufferedWriter toBuffered(Writer writer, int bufferSize) {
        Assert.notNull(writer, "Writer must be not null!", new Object[0]);
        return writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, bufferSize);
    }

    public static InputStream toMarkSupport(InputStream in) {
        if (null == in) {
            return null;
        }
        if (!in.markSupported()) {
            return new BufferedInputStream(in);
        }
        return in;
    }

    public static Reader toMarkSupport(Reader reader) {
        if (null == reader) {
            return null;
        }
        if (!reader.markSupported()) {
            return new BufferedReader(reader);
        }
        return reader;
    }

    public static PushbackReader toPushBackReader(Reader reader, int pushBackSize) {
        return reader instanceof PushbackReader ? (PushbackReader)reader : new PushbackReader(reader, pushBackSize);
    }

    public static PushbackInputStream toPushbackStream(InputStream in, int pushBackSize) {
        return in instanceof PushbackInputStream ? (PushbackInputStream)in : new PushbackInputStream(in, pushBackSize);
    }

    public static InputStream toAvailableStream(InputStream in) {
        if (in instanceof FileInputStream) {
            return in;
        }
        PushbackInputStream pushbackInputStream = IoKit.toPushbackStream(in, 1);
        try {
            int available = pushbackInputStream.available();
            if (available <= 0) {
                int b = pushbackInputStream.read();
                pushbackInputStream.unread(b);
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return pushbackInputStream;
    }

    public static void write(OutputStream out, byte[] content) throws InternalException {
        IoKit.write(out, true, content);
    }

    public static void write(OutputStream out, boolean isCloseOut, byte[] content) throws InternalException {
        StreamWriter.of(out, isCloseOut).write(content);
    }

    public static void write(OutputStream out, boolean isCloseOut, CharSequence ... contents) throws InternalException {
        IoKit.write(out, org.miaixz.bus.core.lang.Charset.UTF_8, isCloseOut, contents);
    }

    public static void write(OutputStream out, Charset charset, boolean isCloseOut, CharSequence ... contents) throws InternalException {
        StreamWriter.of(out, isCloseOut).writeString(charset, contents);
    }

    public static void write(OutputStream out, boolean isCloseOut, Object ... contents) throws InternalException {
        StreamWriter.of(out, isCloseOut).writeObject(contents);
    }

    public static String read(FileChannel fileChannel) throws InternalException {
        return IoKit.read(fileChannel, org.miaixz.bus.core.lang.Charset.UTF_8);
    }

    public static String read(FileChannel fileChannel, Charset charset) throws InternalException {
        MappedByteBuffer buffer;
        try {
            buffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size()).load();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        return StringKit.toString(buffer, charset);
    }

    public static FastByteArrayOutputStream read(ReadableByteChannel channel) throws InternalException {
        FastByteArrayOutputStream out = new FastByteArrayOutputStream();
        IoKit.copy(channel, Channels.newChannel(out));
        return out;
    }

    public static String read(ReadableByteChannel channel, Charset charset) throws InternalException {
        FastByteArrayOutputStream out = IoKit.read(channel);
        return null == charset ? out.toString() : out.toString(charset);
    }

    public static long copy(FileChannel in, FileChannel out) throws InternalException {
        Assert.notNull(in, "In channel is null!", new Object[0]);
        Assert.notNull(out, "Out channel is null!", new Object[0]);
        return FileChannelCopier.of().copy(in, out);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out) throws InternalException {
        return IoKit.copy(in, out, 8192);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize) throws InternalException {
        return IoKit.copy(in, out, bufferSize, null);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, StreamProgress streamProgress) throws InternalException {
        return IoKit.copy(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copy(ReadableByteChannel in, WritableByteChannel out, int bufferSize, long totalCount, StreamProgress streamProgress) {
        Assert.notNull(in, "In channel is null!", new Object[0]);
        Assert.notNull(out, "Out channel is null!", new Object[0]);
        return new ChannelCopier(bufferSize, totalCount, streamProgress).copy(in, out);
    }

    public static long copyNio(InputStream in, OutputStream out, int bufferSize, StreamProgress streamProgress) throws InternalException {
        return IoKit.copyNio(in, out, bufferSize, -1L, streamProgress);
    }

    public static long copyNio(InputStream in, OutputStream out, int bufferSize, long count, StreamProgress streamProgress) throws InternalException {
        Assert.notNull(in, "InputStream channel is null!", new Object[0]);
        Assert.notNull(out, "OutputStream channel is null!", new Object[0]);
        long copySize = IoKit.copy(Channels.newChannel(in), Channels.newChannel(out), bufferSize, count, streamProgress);
        IoKit.flush(out);
        return copySize;
    }

    public static void flush(Flushable flushable) {
        if (null != flushable) {
            try {
                flushable.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Object object) {
        if (object instanceof AutoCloseable) {
            IoKit.closeQuietly((AutoCloseable)object);
        }
    }

    public static void close(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AutoCloseable autoCloseable) {
        if (null != autoCloseable) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(Socket socket) {
        if (null != socket) {
            try {
                socket.close();
            }
            catch (AssertionError e) {
                if (!IoKit.isAndroidGetsocknameError(e)) {
                    throw e;
                }
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(ServerSocket serverSocket) {
        if (null != serverSocket) {
            try {
                serverSocket.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(AsynchronousSocketChannel channel) {
        boolean connected = true;
        try {
            channel.shutdownInput();
        }
        catch (IOException iOException) {
        }
        catch (NotYetConnectedException e) {
            connected = false;
        }
        try {
            if (connected) {
                channel.shutdownOutput();
            }
        }
        catch (IOException | NotYetConnectedException exception) {
            // empty catch block
        }
        try {
            channel.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(AutoCloseable ... closeables) {
        for (AutoCloseable closeable : closeables) {
            IoKit.close(closeable);
        }
    }

    public static boolean isAndroidGetsocknameError(AssertionError e) {
        return null != ((Throwable)((Object)e)).getCause() && null != ((Throwable)((Object)e)).getMessage() && ((Throwable)((Object)e)).getMessage().contains("getsockname failed");
    }

    public static void nullSafeClose(Closeable closeable) throws IOException {
        if (null != closeable) {
            closeable.close();
        }
    }

    public static Sink sink(OutputStream out) {
        return IoKit.sink(out, new Timeout());
    }

    private static Sink sink(final OutputStream out, final Timeout timeout) {
        if (null == out) {
            throw new IllegalArgumentException("out == null");
        }
        if (null == timeout) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) throws IOException {
                IoKit.checkOffsetAndCount(source.size, 0L, byteCount);
                while (byteCount > 0L) {
                    timeout.throwIfReached();
                    SectionBuffer head = source.head;
                    int toCopy = (int)Math.min(byteCount, (long)(head.limit - head.pos));
                    out.write(head.data, head.pos, toCopy);
                    head.pos += toCopy;
                    byteCount -= (long)toCopy;
                    source.size -= (long)toCopy;
                    if (head.pos != head.limit) continue;
                    source.head = head.pop();
                    LifeCycle.recycle(head);
                }
            }

            @Override
            public void flush() throws IOException {
                out.flush();
            }

            @Override
            public void close() throws IOException {
                out.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "sink(" + String.valueOf(out) + ")";
            }
        };
    }

    public static Sink sink(Socket socket) throws IOException {
        if (null == socket) {
            throw new IllegalArgumentException("socket == null");
        }
        if (null == socket.getOutputStream()) {
            throw new IOException("socket's output stream == null");
        }
        AsyncTimeout timeout = IoKit.timeout(socket);
        Sink sink = IoKit.sink(socket.getOutputStream(), timeout);
        return timeout.sink(sink);
    }

    public static Source source(InputStream in) {
        return IoKit.source(in, new Timeout());
    }

    private static Source source(final InputStream in, final Timeout timeout) {
        if (null == in) {
            throw new IllegalArgumentException("in == null");
        }
        if (null == timeout) {
            throw new IllegalArgumentException("timeout == null");
        }
        return new Source(){

            @Override
            public long read(Buffer sink, long byteCount) throws IOException {
                if (byteCount < 0L) {
                    throw new IllegalArgumentException("byteCount < 0: " + byteCount);
                }
                if (byteCount == 0L) {
                    return 0L;
                }
                try {
                    timeout.throwIfReached();
                    SectionBuffer tail = sink.writableSegment(1);
                    int maxToCopy = (int)Math.min(byteCount, (long)(8192 - tail.limit));
                    int bytesRead = in.read(tail.data, tail.limit, maxToCopy);
                    if (bytesRead == -1) {
                        if (tail.pos == tail.limit) {
                            sink.head = tail.pop();
                            LifeCycle.recycle(tail);
                        }
                        return -1L;
                    }
                    tail.limit += bytesRead;
                    sink.size += (long)bytesRead;
                    return bytesRead;
                }
                catch (AssertionError e) {
                    if (IoKit.isAndroidGetsocknameError(e)) {
                        throw new IOException((Throwable)((Object)e));
                    }
                    throw e;
                }
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            @Override
            public Timeout timeout() {
                return timeout;
            }

            public String toString() {
                return "source(" + String.valueOf(in) + ")";
            }
        };
    }

    public static Source source(File file) throws FileNotFoundException {
        if (null == file) {
            throw new IllegalArgumentException("file == null");
        }
        return IoKit.source(new FileInputStream(file));
    }

    public static Source source(Path path, OpenOption ... options) throws IOException {
        if (null == path) {
            throw new IllegalArgumentException("path == null");
        }
        return IoKit.source(Files.newInputStream(path, options));
    }

    public static Sink sink(File file) throws FileNotFoundException {
        if (null == file) {
            throw new IllegalArgumentException("file == null");
        }
        return IoKit.sink(new FileOutputStream(file));
    }

    public static Sink appendingSink(File file) throws FileNotFoundException {
        if (null == file) {
            throw new IllegalArgumentException("file == null");
        }
        return IoKit.sink(new FileOutputStream(file, true));
    }

    public static Sink sink(Path path, OpenOption ... options) throws IOException {
        if (null == path) {
            throw new IllegalArgumentException("path == null");
        }
        return IoKit.sink(Files.newOutputStream(path, options));
    }

    public static Sink blackhole() {
        return new Sink(){

            @Override
            public void write(Buffer source, long byteCount) throws IOException {
                source.skip(byteCount);
            }

            @Override
            public void flush() {
            }

            @Override
            public Timeout timeout() {
                return Timeout.NONE;
            }

            @Override
            public void close() {
            }
        };
    }

    public static Source source(Socket socket) throws IOException {
        if (null == socket) {
            throw new IllegalArgumentException("socket == null");
        }
        if (null == socket.getInputStream()) {
            throw new IOException("socket's input stream == null");
        }
        AsyncTimeout timeout = IoKit.timeout(socket);
        Source source = IoKit.source(socket.getInputStream(), timeout);
        return timeout.source(source);
    }

    private static AsyncTimeout timeout(final Socket socket) {
        return new AsyncTimeout(){

            @Override
            protected IOException newTimeoutException(IOException cause) {
                SocketTimeoutException ioe = new SocketTimeoutException("timeout");
                if (null != cause) {
                    ioe.initCause(cause);
                }
                return ioe;
            }

            @Override
            protected void timedOut() {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    Console.log("Failed to close timed out socket " + String.valueOf(socket), e);
                }
                catch (AssertionError e) {
                    if (IoKit.isAndroidGetsocknameError(e)) {
                        Console.log("Failed to close timed out socket " + String.valueOf(socket), e);
                    }
                    throw e;
                }
            }
        };
    }

    public static boolean contentEquals(InputStream input1, InputStream input2) throws InternalException {
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static boolean contentEquals(Reader input1, Reader input2) throws InternalException {
        input1 = IoKit.toBuffered(input1);
        input2 = IoKit.toBuffered(input2);
        try {
            int ch2;
            int ch = input1.read();
            while (-1 != ch) {
                ch2 = input2.read();
                if (ch != ch2) {
                    return false;
                }
                ch = input1.read();
            }
            ch2 = input2.read();
            return ch2 == -1;
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static boolean contentEqualsIgnoreEOL(Reader input1, Reader input2) throws InternalException {
        BufferedReader br1 = IoKit.toBuffered(input1);
        BufferedReader br2 = IoKit.toBuffered(input2);
        try {
            String line1 = br1.readLine();
            String line2 = br2.readLine();
            while (line1 != null && line1.equals(line2)) {
                line1 = br1.readLine();
                line2 = br2.readLine();
            }
            return Objects.equals(line1, line2);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static LineIterator lineIter(Reader reader) {
        return new LineIterator(reader);
    }

    public static LineIterator lineIter(InputStream in, Charset charset) {
        return new LineIterator(in, charset);
    }

    public static String toString(ByteArrayOutputStream out, Charset charset) {
        return out.toString(charset);
    }

    public static void checkOffsetAndCount(long size, long offset, long byteCount) {
        if ((offset | byteCount) < 0L || offset > size || size - offset < byteCount) {
            throw new ArrayIndexOutOfBoundsException(String.format("size=%s offset=%s byteCount=%s", size, offset, byteCount));
        }
    }

    public static void sneakyRethrow(Throwable t) {
        IoKit.sneakyThrow2(t);
    }

    private static <T extends Throwable> void sneakyThrow2(Throwable t) throws T {
        throw t;
    }

    public static boolean arrayRangeEquals(byte[] a, int aOffset, byte[] b, int bOffset, int byteCount) {
        for (int i = 0; i < byteCount; ++i) {
            if (a[i + aOffset] == b[i + bOffset]) continue;
            return false;
        }
        return true;
    }

    public static BufferSource buffer(Source source) {
        return new RealSource(source);
    }

    public static BufferSink buffer(Sink sink) {
        return new RealSink(sink);
    }

    public static short reverseBytesShort(short s) {
        int i = s & 0xFFFF;
        int reversed = (i & 0xFF00) >>> 8 | (i & 0xFF) << 8;
        return (short)reversed;
    }

    public static int reverseBytesInt(int i) {
        return (i & 0xFF000000) >>> 24 | (i & 0xFF0000) >>> 8 | (i & 0xFF00) << 8 | (i & 0xFF) << 24;
    }

    public static long reverseBytesLong(long v) {
        return (v & 0xFF00000000000000L) >>> 56 | (v & 0xFF000000000000L) >>> 40 | (v & 0xFF0000000000L) >>> 24 | (v & 0xFF00000000L) >>> 8 | (v & 0xFF000000L) << 8 | (v & 0xFF0000L) << 24 | (v & 0xFF00L) << 40 | (v & 0xFFL) << 56;
    }

    public static InputStream openFileOrURL(String name) throws IOException {
        if (name.startsWith("resource:")) {
            URL url = ResourceKit.getResourceUrl(name.substring(9), IoKit.class);
            if (null == url) {
                throw new FileNotFoundException(name);
            }
            return url.openStream();
        }
        if (name.indexOf(58) < 2) {
            return new FileInputStream(name);
        }
        return new URL(name).openStream();
    }

    public static int length(InputStream in) {
        if (in instanceof FileInputStream) {
            try {
                return in.available();
            }
            catch (IOException e) {
                throw new InternalException(e);
            }
        }
        return -1;
    }
}

