/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.miaixz.bus.core.center.object.ObjectValidator;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.ArrayKit;
import org.miaixz.bus.core.xyz.ClassKit;
import org.miaixz.bus.core.xyz.MethodKit;
import org.miaixz.bus.core.xyz.SerializeKit;

public class ObjectKit
extends ObjectValidator {
    public static int length(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof CharSequence) {
            return ((CharSequence)object).length();
        }
        if (object instanceof Collection) {
            return ((Collection)object).size();
        }
        if (object instanceof Map) {
            return ((Map)object).size();
        }
        int count = 0;
        if (object instanceof Iterator || object instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = object instanceof Iterator ? (Iterator)object : ((Iterable)object).iterator();
            while (iter.hasNext()) {
                ++count;
                iter.next();
            }
            return count;
        }
        if (object.getClass().isArray()) {
            return Array.getLength(object);
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                ++count;
                enumeration.nextElement();
            }
            return count;
        }
        return -1;
    }

    public static boolean contains(Object object, Object element) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            if (element == null) {
                return false;
            }
            return ((String)object).contains(element.toString());
        }
        if (object instanceof Collection) {
            return ((Collection)object).contains(element);
        }
        if (object instanceof Map) {
            return ((Map)object).containsValue(element);
        }
        if (object instanceof Iterator || object instanceof Iterable) {
            Iterator iter;
            Iterator iterator = iter = object instanceof Iterator ? (Iterator)object : ((Iterable)object).iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            while (enumeration.hasMoreElements()) {
                Object o = enumeration.nextElement();
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
            return false;
        }
        if (ArrayKit.isArray(object)) {
            int len = Array.getLength(object);
            for (int i = 0; i < len; ++i) {
                Object o = Array.get(object, i);
                if (!ObjectKit.equals(o, element)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T, R> R apply(T source, Function<T, R> handler) {
        return ObjectKit.defaultIfNull(source, handler, null);
    }

    public static <T> void accept(T source, Consumer<T> consumer) {
        if (null != source) {
            consumer.accept(source);
        }
    }

    public static <T> T clone(T object) {
        T result = ArrayKit.clone(object);
        if (null != result) {
            return result;
        }
        if (object instanceof Cloneable) {
            try {
                return MethodKit.invoke(object, "clone", new Object[0]);
            }
            catch (InternalException e) {
                if (e.getCause() instanceof IllegalAccessException) {
                    return ObjectKit.cloneByStream(object);
                }
                throw e;
            }
        }
        return ObjectKit.cloneByStream(object);
    }

    public static <T> T cloneIfPossible(T object) {
        Object clone = null;
        try {
            clone = ObjectKit.clone(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (T)(clone == null ? object : clone);
    }

    public static <T> T cloneByStream(T object) {
        return SerializeKit.clone(object);
    }

    public static Class<?> getTypeArgument(Object object) {
        return ObjectKit.getTypeArgument(object, 0);
    }

    public static Class<?> getTypeArgument(Object object, int index) {
        return ClassKit.getTypeArgument(object.getClass(), index);
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (null == o1 || null == o2) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ArrayKit.arrayEquals(o1, o2);
        }
        return false;
    }
}

