/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.miaixz.bus.core.center.set.SetFromMap;
import org.miaixz.bus.core.xyz.ArrayKit;

public class SetKit {
    public static <T> HashSet<T> of(boolean isLinked) {
        return SetKit._of(isLinked, null);
    }

    @SafeVarargs
    public static <T> HashSet<T> of(T ... ts) {
        return SetKit._of(false, ts);
    }

    @SafeVarargs
    public static <T> LinkedHashSet<T> ofLinked(T ... ts) {
        return (LinkedHashSet)SetKit._of(true, ts);
    }

    public static <T> HashSet<T> of(Iterable<T> iterable) {
        return SetKit.of(false, iterable);
    }

    public static <T> HashSet<T> of(boolean isLinked, Iterable<T> iterable) {
        if (null == iterable) {
            return SetKit.of(isLinked);
        }
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            return isLinked ? new LinkedHashSet(collection) : new HashSet(collection);
        }
        return SetKit.of(isLinked, iterable.iterator());
    }

    public static <T> HashSet<T> of(boolean isSorted, Iterator<T> iter) {
        HashSet set;
        if (null == iter) {
            return SetKit._of(isSorted, null);
        }
        HashSet hashSet = set = isSorted ? new LinkedHashSet() : new HashSet();
        while (iter.hasNext()) {
            set.add(iter.next());
        }
        return set;
    }

    public static <T> HashSet<T> of(boolean isLinked, Enumeration<T> enumeration) {
        HashSet set;
        if (null == enumeration) {
            return SetKit._of(isLinked, null);
        }
        HashSet hashSet = set = isLinked ? new LinkedHashSet() : new HashSet();
        while (enumeration.hasMoreElements()) {
            set.add(enumeration.nextElement());
        }
        return set;
    }

    public static <T> SetFromMap<T> of(Map<T, Boolean> map) {
        return new SetFromMap<T>(map);
    }

    @SafeVarargs
    public static <T> Set<T> view(T ... ts) {
        return SetKit.view(SetKit.of(ts));
    }

    public static <T> Set<T> view(Set<T> ts) {
        if (ArrayKit.isEmpty(ts)) {
            return SetKit.empty();
        }
        return Collections.unmodifiableSet(ts);
    }

    public static <T> Set<T> empty() {
        return Collections.emptySet();
    }

    public static <T> Set<T> zero() {
        return new HashSet(0, 1.0f);
    }

    public static <T> Set<T> singleton(T element) {
        return Collections.singleton(element);
    }

    public static <T> Set<T> zeroLinked() {
        return new LinkedHashSet(0, 1.0f);
    }

    public static <T> Set<T> unmodifiable(Set<? extends T> c) {
        if (null == c) {
            return null;
        }
        return Collections.unmodifiableSet(c);
    }

    private static <T> HashSet<T> _of(boolean isLinked, T[] ts) {
        if (ArrayKit.isEmpty(ts)) {
            return isLinked ? new LinkedHashSet() : new HashSet();
        }
        int initialCapacity = Math.max((int)((float)ts.length / 0.75f) + 1, 16);
        HashSet set = isLinked ? new LinkedHashSet(initialCapacity) : new HashSet(initialCapacity);
        Collections.addAll(set, ts);
        return set;
    }
}

