/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.core.xyz;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.miaixz.bus.core.tree.MapTree;
import org.miaixz.bus.core.tree.NodeConfig;
import org.miaixz.bus.core.tree.TreeBuilder;
import org.miaixz.bus.core.tree.TreeNode;
import org.miaixz.bus.core.tree.parser.DefaultNodeParser;
import org.miaixz.bus.core.tree.parser.NodeParser;
import org.miaixz.bus.core.xyz.CollKit;
import org.miaixz.bus.core.xyz.ObjectKit;

public class TreeKit {
    public static MapTree<Integer> buildSingle(Iterable<TreeNode<Integer>> list) {
        return TreeKit.buildSingle(list, Integer.valueOf(0));
    }

    public static List<MapTree<Integer>> build(Iterable<TreeNode<Integer>> list) {
        return TreeKit.build(list, Integer.valueOf(0));
    }

    public static <E> MapTree<E> buildSingle(Iterable<TreeNode<E>> list, E parentId) {
        return TreeKit.buildSingle(list, parentId, NodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <E> List<MapTree<E>> build(Iterable<TreeNode<E>> list, E parentId) {
        return TreeKit.build(list, parentId, NodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> MapTree<E> buildSingle(Iterable<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeKit.buildSingle(list, parentId, NodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<MapTree<E>> build(Iterable<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeKit.build(list, parentId, NodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<MapTree<E>> build(Iterable<T> list, E rootId, NodeConfig NodeConfig2, NodeParser<T, E> nodeParser) {
        return TreeKit.buildSingle(list, rootId, NodeConfig2, nodeParser).getChildren();
    }

    public static <T, E> MapTree<E> buildSingle(Iterable<T> list, E rootId, NodeConfig NodeConfig2, NodeParser<T, E> nodeParser) {
        return TreeBuilder.of(rootId, NodeConfig2).append(list, nodeParser).build();
    }

    public static <E> List<MapTree<E>> build(Map<E, MapTree<E>> map, E rootId) {
        return TreeKit.buildSingle(map, rootId).getChildren();
    }

    public static <E> MapTree<E> buildSingle(Map<E, MapTree<E>> map, E rootId) {
        MapTree<E> tree = CollKit.getFirstNoneNull(map.values());
        if (null != tree) {
            NodeConfig config = tree.getConfig();
            return TreeBuilder.of(rootId, config).append(map).build();
        }
        return TreeKit.createEmptyNode(rootId);
    }

    public static <T> MapTree<T> getNode(MapTree<T> node, T id) {
        if (ObjectKit.equals(id, node.getId())) {
            return node;
        }
        List<MapTree<T>> children = node.getChildren();
        if (null == children) {
            return null;
        }
        for (MapTree<T> child : children) {
            MapTree<T> childNode = child.getNode(id);
            if (null == childNode) continue;
            return childNode;
        }
        return null;
    }

    public static <T> List<CharSequence> getParentsName(MapTree<T> node, boolean includeCurrentNode) {
        return TreeKit.getParents(node, includeCurrentNode, MapTree::getName);
    }

    public static <T> List<T> getParentsId(MapTree<T> node, boolean includeCurrentNode) {
        return TreeKit.getParents(node, includeCurrentNode, MapTree::getId);
    }

    public static <T, E> List<E> getParents(MapTree<T> node, boolean includeCurrentNode, Function<MapTree<T>, E> fieldFunc) {
        ArrayList<E> result = new ArrayList<E>();
        if (null == node) {
            return result;
        }
        if (includeCurrentNode) {
            result.add(fieldFunc.apply(node));
        }
        for (MapTree<T> parent = node.getParent(); null != parent; parent = parent.getParent()) {
            E fieldValue = fieldFunc.apply(parent);
            if (null == fieldValue && null == parent) continue;
            result.add(fieldValue);
        }
        return result;
    }

    public static <E> MapTree<E> createEmptyNode(E id) {
        return new MapTree().setId(id);
    }

    public static <E> List<MapTree<E>> toList(MapTree<E> root, boolean broadFirst) {
        if (Objects.isNull(root)) {
            return null;
        }
        ArrayList<MapTree<E>> list = new ArrayList<MapTree<E>>();
        root.walk(list::add, broadFirst);
        return list;
    }
}

