/*********************************************************************************
 *                                                                               *
 * The MIT License (MIT)                                                         *
 *                                                                               *
 * Copyright (c) 2015-2024 miaixz.org and other contributors.                    *
 *                                                                               *
 * Permission is hereby granted, free of charge, to any person obtaining a copy  *
 * of this software and associated documentation files (the "Software"), to deal *
 * in the Software without restriction, including without limitation the rights  *
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell     *
 * copies of the Software, and to permit persons to whom the Software is         *
 * furnished to do so, subject to the following conditions:                      *
 *                                                                               *
 * The above copyright notice and this permission notice shall be included in    *
 * all copies or substantial portions of the Software.                           *
 *                                                                               *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR    *
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,      *
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE   *
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER        *
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, *
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN     *
 * THE SOFTWARE.                                                                 *
 *                                                                               *
 ********************************************************************************/
package org.miaixz.bus.extra.template;

import java.io.Writer;
import java.util.Map;

/**
 * 提供模板工具类，用于快捷模板融合
 *
 * @author Kimi Liu
 * @since Java 17+
 */
public class TemplateKit {

    /**
     * 获取单例的模板引擎
     *
     * @return {@link TemplateProvider}
     */
    public static TemplateProvider getEngine() {
        return TemplateFactory.getEngine();
    }

    /**
     * 融合模板和参数，返回融合后的内容
     *
     * @param templateContent 模板内容
     * @param bindingMap      参数
     * @return 内容
     */
    public static String render(final String templateContent, final Map<?, ?> bindingMap) {
        return getEngine().getTemplate(templateContent).render(bindingMap);
    }

    /**
     * 融合模板和参数，返回融合后的内容
     *
     * @param templateContent 模板内容
     * @param bindingMap      参数
     * @param writer          融合内容输出的位置
     */
    public static void render(final String templateContent, final Map<?, ?> bindingMap, final Writer writer) {
        getEngine().getTemplate(templateContent).render(bindingMap, writer);
    }
}
