/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.captcha;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.miaixz.bus.core.codec.binary.Base64;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.FileKit;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.UrlKit;
import org.miaixz.bus.extra.captcha.ICaptcha;
import org.miaixz.bus.extra.captcha.generator.CodeGenerator;
import org.miaixz.bus.extra.captcha.generator.RandomGenerator;
import org.miaixz.bus.extra.image.ImageKit;

public abstract class AbstractCaptcha
implements ICaptcha {
    private static final long serialVersionUID = -1L;
    protected int width;
    protected int height;
    protected int interfereCount;
    protected Font font;
    protected String code;
    protected byte[] imageBytes;
    protected CodeGenerator generator;
    protected Color background = Color.WHITE;
    protected AlphaComposite textAlpha;

    public AbstractCaptcha(int width, int height, int codeCount, int interfereCount) {
        this(width, height, new RandomGenerator(codeCount), interfereCount);
    }

    public AbstractCaptcha(int width, int height, CodeGenerator generator, int interfereCount) {
        this(width, height, generator, interfereCount, 0.75f);
    }

    public AbstractCaptcha(int width, int height, CodeGenerator generator, int interfereCount, float sizeBaseHeight) {
        this.width = width;
        this.height = height;
        this.generator = generator;
        this.interfereCount = interfereCount;
        this.font = new Font("SansSerif", 0, (int)((float)this.height * sizeBaseHeight));
    }

    @Override
    public void createCode() {
        this.generateCode();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Image image = null;
        try {
            image = this.createImage(this.code);
            ImageKit.writePng(image, out);
        }
        catch (Throwable throwable) {
            ImageKit.flush(image);
            throw throwable;
        }
        ImageKit.flush(image);
        this.imageBytes = out.toByteArray();
    }

    protected void generateCode() {
        this.code = this.generator.generate();
    }

    protected abstract Image createImage(String var1);

    @Override
    public String getCode() {
        if (null == this.code) {
            this.createCode();
        }
        return this.code;
    }

    @Override
    public boolean verify(String userInputCode) {
        return this.generator.verify(this.getCode(), userInputCode);
    }

    public void write(String path) throws InternalException {
        this.write(FileKit.touch((String)path));
    }

    public void write(File file) throws InternalException {
        try (BufferedOutputStream out = FileKit.getOutputStream((File)file);){
            this.write(out);
        }
        catch (IOException e) {
            throw new InternalException((Throwable)e);
        }
    }

    @Override
    public void write(OutputStream out) {
        IoKit.write((OutputStream)out, (boolean)false, (byte[])this.getImageBytes());
    }

    public byte[] getImageBytes() {
        if (null == this.imageBytes) {
            this.createCode();
        }
        return this.imageBytes;
    }

    public BufferedImage getImage() {
        return ImageKit.read(IoKit.toStream((byte[])this.getImageBytes()));
    }

    public String getImageBase64() {
        return Base64.encode((byte[])this.getImageBytes());
    }

    public String getImageBase64Data() {
        return UrlKit.getDataUriBase64((String)"image/png", (String)this.getImageBase64());
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public CodeGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(CodeGenerator generator) {
        this.generator = generator;
    }

    public void setBackground(Color background) {
        this.background = background;
    }

    public void setTextAlpha(float textAlpha) {
        this.textAlpha = AlphaComposite.getInstance(3, textAlpha);
    }
}

