/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.captcha.generator;

import org.miaixz.bus.core.math.Calculator;
import org.miaixz.bus.core.xyz.RandomKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.captcha.generator.CodeGenerator;

public class MathGenerator
implements CodeGenerator {
    private static final long serialVersionUID = -1L;
    private static final String operators = "+-*";
    private final int numberLength;

    public MathGenerator() {
        this(2);
    }

    public MathGenerator(int numberLength) {
        this.numberLength = numberLength;
    }

    @Override
    public String generate() {
        int limit = this.getLimit();
        String number1 = Integer.toString(RandomKit.randomInt((int)limit));
        String number2 = Integer.toString(RandomKit.randomInt((int)limit));
        number1 = StringKit.padAfter((CharSequence)number1, (int)this.numberLength, (char)' ');
        number2 = StringKit.padAfter((CharSequence)number2, (int)this.numberLength, (char)' ');
        return StringKit.builder().append(number1).append(RandomKit.randomChar((String)operators)).append(number2).append('=').toString();
    }

    @Override
    public boolean verify(String code, String userInputCode) {
        int result;
        try {
            result = Integer.parseInt(userInputCode);
        }
        catch (NumberFormatException e) {
            return false;
        }
        int calculateResult = (int)Calculator.conversion((String)code);
        return result == calculateResult;
    }

    public int getLength() {
        return this.numberLength * 2 + 2;
    }

    private int getLimit() {
        return Integer.parseInt("1" + StringKit.repeat((char)'0', (int)this.numberLength));
    }
}

