/*
 * Decompiled with CFR 0.152.
 */
package org.miaixz.bus.extra.compress;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.miaixz.bus.core.lang.exception.InternalException;
import org.miaixz.bus.core.xyz.IoKit;
import org.miaixz.bus.core.xyz.StringKit;
import org.miaixz.bus.extra.compress.archiver.Archiver;
import org.miaixz.bus.extra.compress.archiver.SevenZArchiver;
import org.miaixz.bus.extra.compress.archiver.StreamArchiver;
import org.miaixz.bus.extra.compress.extractor.Extractor;
import org.miaixz.bus.extra.compress.extractor.SevenZExtractor;
import org.miaixz.bus.extra.compress.extractor.StreamExtractor;

public class CompressKit {
    public static CompressorOutputStream getOut(String compressorName, OutputStream out) {
        try {
            return new CompressorStreamFactory().createCompressorOutputStream(compressorName, out);
        }
        catch (CompressorException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static CompressorInputStream getIn(String compressorName, InputStream in) {
        in = IoKit.toMarkSupport((InputStream)in);
        try {
            if (StringKit.isBlank((CharSequence)compressorName)) {
                compressorName = CompressorStreamFactory.detect((InputStream)in);
            }
            return new CompressorStreamFactory().createCompressorInputStream(compressorName, in);
        }
        catch (CompressorException e) {
            throw new InternalException((Throwable)e);
        }
    }

    public static Archiver createArchiver(Charset charset, String archiverName, File file) {
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZArchiver(file);
        }
        return StreamArchiver.of(charset, archiverName, file);
    }

    public static Archiver createArchiver(Charset charset, String archiverName, OutputStream out) {
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZArchiver(out);
        }
        return StreamArchiver.of(charset, archiverName, out);
    }

    public static Extractor createExtractor(Charset charset, File file) {
        return CompressKit.createExtractor(charset, null, file);
    }

    public static Extractor createExtractor(Charset charset, String archiverName, File file) {
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZExtractor(file);
        }
        try {
            return new StreamExtractor(charset, archiverName, file);
        }
        catch (InternalException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StreamingNotSupportedException && cause.getMessage().contains("7z")) {
                return new SevenZExtractor(file);
            }
            throw e;
        }
    }

    public static Extractor createExtractor(Charset charset, InputStream in) {
        return CompressKit.createExtractor(charset, null, in);
    }

    public static Extractor createExtractor(Charset charset, String archiverName, InputStream in) {
        if ("7z".equalsIgnoreCase(archiverName)) {
            return new SevenZExtractor(in);
        }
        try {
            return new StreamExtractor(charset, archiverName, in);
        }
        catch (InternalException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StreamingNotSupportedException && cause.getMessage().contains("7z")) {
                return new SevenZExtractor(in);
            }
            throw e;
        }
    }
}

